/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal.attacker;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import org.jetbrains.annotations.Nullable;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.misc.AnimatedAttacker;
import team.recrafted.blastfromthepast.mixin.MeleeAttackGoalAccessor;
import team.recrafted.blastfromthepast.util.DebugFlags;

public class AnimatedMeleeAttackGoal<T extends PathfinderMob, A extends AnimatedAttacker.AttackType<T, A>>
extends MeleeAttackGoal {
    private final T attacker;
    @Nullable
    private A selectedAttackType;

    public AnimatedMeleeAttackGoal(T pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.attacker = pMob;
    }

    public void start() {
        super.start();
        this.selectedAttackType = null;
    }

    public void stop() {
        super.stop();
        this.selectedAttackType = null;
    }

    protected void checkAndPerformAttack(LivingEntity pEnemy) {
        if (this.isTimeToAttack() && ((AnimatedAttacker)this.attacker).getActiveAttackType() == null && this.selectedAttackType == null) {
            this.selectedAttackType = ((AnimatedAttacker)this.attacker).selectAttackTypeForTarget(pEnemy);
            if (DebugFlags.DEBUG_ANIMATED_ATTACK) {
                BlastFromThePast.LOGGER.info("{} selected attack type {}", this.attacker, this.selectedAttackType);
            }
        }
        if (this.canPerformAttack(pEnemy)) {
            ((AnimatedAttacker)this.attacker).setActiveAttackType(this.selectedAttackType);
            if (DebugFlags.DEBUG_ANIMATED_ATTACK) {
                BlastFromThePast.LOGGER.info("{} is activating attack type {}", this.attacker, this.selectedAttackType);
            }
            this.selectedAttackType = null;
            this.resetAttackCooldown();
        }
    }

    protected boolean canPerformAttack(LivingEntity target) {
        return this.isTimeToAttack() && this.selectedAttackType != null && this.selectedAttackType.isTargetCloseEnoughToStart(this.attacker, target) && this.mob.getSensing().hasLineOfSight((Entity)target);
    }

    protected void resetAttackCooldown() {
        int attackCooldown = 20;
        Object activeAttack = ((AnimatedAttacker)this.attacker).getActiveAttackType();
        if (activeAttack != null) {
            attackCooldown += activeAttack.getAttackDuration();
        }
        ((MeleeAttackGoalAccessor)((Object)this)).blastfromthepast$setTicksUntilNextAttack(this.adjustedTickDelay(attackCooldown));
    }
}

