/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import team.recrafted.blastfromthepast.block.SnowdoEggBlock;
import team.recrafted.blastfromthepast.init.ModBlocks;

public class SnowdoBreedGoal
extends Goal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.forNonCombat().range(8.0).ignoreLineOfSight();
    protected final Animal animal;
    private final Class<? extends Animal> partnerClass;
    protected final Level level;
    @Nullable
    protected Animal partner;
    private int loveTime;
    private final double speedModifier;

    public SnowdoBreedGoal(Animal animal, double speedModifier) {
        this(animal, speedModifier, animal.getClass());
    }

    public SnowdoBreedGoal(Animal animal, double speedModifier, Class<? extends Animal> partnerClass) {
        this.animal = animal;
        this.level = animal.level();
        this.partnerClass = partnerClass;
        this.speedModifier = speedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.animal.isInLove()) {
            return false;
        }
        this.partner = this.getFreePartner();
        return this.partner != null;
    }

    public boolean canContinueToUse() {
        return this.partner.isAlive() && this.partner.isInLove() && this.loveTime < 60 && !this.partner.isPanicking();
    }

    public void stop() {
        this.partner = null;
        this.loveTime = 0;
    }

    public void tick() {
        this.animal.getLookControl().setLookAt((Entity)this.partner, 10.0f, (float)this.animal.getMaxHeadXRot());
        this.animal.getNavigation().moveTo((Entity)this.partner, this.speedModifier);
        ++this.loveTime;
        if (this.loveTime >= this.adjustedTickDelay(60) && this.animal.distanceToSqr((Entity)this.partner) < 9.0) {
            this.breed();
        }
    }

    @Nullable
    private Animal getFreePartner() {
        List list = this.level.getNearbyEntities(this.partnerClass, PARTNER_TARGETING, (LivingEntity)this.animal, this.animal.getBoundingBox().inflate(8.0));
        double d0 = Double.MAX_VALUE;
        Animal animal = null;
        for (Animal animal1 : list) {
            if (!this.animal.canMate(animal1) || animal1.isPanicking() || !(this.animal.distanceToSqr((Entity)animal1) < d0)) continue;
            animal = animal1;
            d0 = this.animal.distanceToSqr((Entity)animal1);
        }
        return animal;
    }

    protected void breed() {
        int number = this.animal.getRandom().nextInt(3) + 1;
        boolean eggSpawnFailed = false;
        BlockState snowdoEggs = (BlockState)((Block)ModBlocks.SNOWDO_EGG.get()).defaultBlockState().setValue((Property)SnowdoEggBlock.EGGS, (Comparable)Integer.valueOf(number));
        BlockPos eggsPos = this.animal.blockPosition();
        if (!this.animal.level().getBlockState(this.animal.blockPosition()).isEmpty() && (eggsPos = this.findSuitableEggPosition(this.animal.blockPosition())) == this.animal.blockPosition()) {
            eggSpawnFailed = true;
        }
        if (!eggSpawnFailed) {
            this.level.setBlock(eggsPos, snowdoEggs, 2);
        }
        this.animal.setAge(6000);
        assert (this.partner != null);
        this.partner.setAge(6000);
        this.animal.resetLove();
        this.partner.resetLove();
    }

    private BlockPos findSuitableEggPosition(BlockPos startPos) {
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)startPos.offset(-1, -1, -1), (BlockPos)startPos.offset(1, 1, 1))) {
            if (!this.level.getBlockState(pos).isAir() || !this.level.getBlockState(pos.below()).isSolid()) continue;
            return pos;
        }
        return startPos;
    }
}

