/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.misc.BackScratcher;
import team.recrafted.blastfromthepast.util.DebugFlags;
import team.recrafted.blastfromthepast.util.EntityHelper;
import team.recrafted.blastfromthepast.util.HitboxHelper;

public class ScratchBackOnTreeGoal<T extends PathfinderMob>
extends MoveToBlockGoal {
    private static final int MAX_BACK_SCRATCH_TIME = 120;
    private final T backScratcher;
    private final Predicate<BlockState> isBackScratchBlock;
    private boolean wantsToScratchBack;
    private boolean canScratchBack;
    private boolean turning;
    private int backScratchCounter = 0;

    public ScratchBackOnTreeGoal(T mob, double speedModifier, int searchRange, Predicate<BlockState> isBackScratchBlock) {
        this(mob, speedModifier, searchRange, 1, isBackScratchBlock);
    }

    public ScratchBackOnTreeGoal(T mob, double speedModifier, int searchRange, int verticalSearchRange, Predicate<BlockState> isBackScratchBlock) {
        super(mob, speedModifier, searchRange, verticalSearchRange);
        this.backScratcher = mob;
        this.isBackScratchBlock = isBackScratchBlock;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.mob.isSleeping()) {
            return false;
        }
        if (this.nextStartTick <= 0) {
            this.canScratchBack = false;
            this.wantsToScratchBack = ((BackScratcher)this.backScratcher).wantsToScratchBack();
            if (this.wantsToScratchBack && DebugFlags.DEBUG_BACK_SCRATCH) {
                BlastFromThePast.LOGGER.info("{} is ready to look for a tree to scratch their back on!", this.backScratcher);
            }
        }
        return super.canUse();
    }

    protected int nextStartTick(PathfinderMob creature) {
        return DebugFlags.DEBUG_BACK_SCRATCH ? 40 : super.nextStartTick(creature);
    }

    public void start() {
        ((BackScratcher)this.backScratcher).setPreparingToScratchBack(true);
        this.backScratchCounter = 0;
        this.turning = false;
        super.start();
    }

    public boolean canContinueToUse() {
        if (this.mob.isSleeping()) {
            return false;
        }
        if (this.canScratchBack && (this.backScratchCounter > 0 || this.turning)) {
            return true;
        }
        return this.canScratchBack && (((BackScratcher)this.backScratcher).isPreparingToScratchBack() || super.canContinueToUse());
    }

    public double acceptedDistance() {
        return HitboxHelper.getHitboxAdjustedDistance(this.backScratcher.getBbWidth(), 1.0);
    }

    public void tick() {
        super.tick();
        boolean stopScratchingBack = false;
        if (this.backScratchCounter > 0) {
            --this.backScratchCounter;
            if (this.backScratchCounter <= 0) {
                stopScratchingBack = true;
            }
        }
        Vec3 lookTarget = new Vec3((double)this.blockPos.getX() + 0.5, (double)(this.blockPos.getY() + 1), (double)this.blockPos.getZ() + 0.5);
        this.turning = false;
        if (this.isReachedTarget()) {
            boolean backScratching = false;
            Level level = this.backScratcher.level();
            BlockPos above = this.blockPos.above();
            if (this.canScratchBack && this.isTree((LevelReader)level, this.blockPos)) {
                backScratching = true;
                if (stopScratchingBack) {
                    ((BackScratcher)this.backScratcher).scratchedBack();
                    ((BackScratcher)this.backScratcher).setBackScratching(false);
                } else if (this.backScratchCounter <= 0) {
                    if (EntityHelper.isLookingAwayFrom(this.backScratcher, lookTarget, 0.025, true, false)) {
                        if (DebugFlags.DEBUG_BACK_SCRATCH) {
                            BlastFromThePast.LOGGER.info("{} is scratching their back on a tree at {}", this.backScratcher, (Object)above);
                        }
                        ((BackScratcher)this.backScratcher).setBackScratching(true);
                        ((BackScratcher)this.backScratcher).playBackScratchSound();
                        this.backScratchCounter = 120;
                    } else {
                        this.turning = true;
                        if (DebugFlags.DEBUG_BACK_SCRATCH) {
                            BlastFromThePast.LOGGER.info("{} is turning around to face away from {}", this.backScratcher, (Object)above);
                        }
                        Vec3 lookAwayOffset = lookTarget.vectorTo(this.backScratcher.getEyePosition()).multiply(1.0, 0.0, 1.0).normalize().scale(HitboxHelper.getHitboxAdjustedDistance(this.backScratcher, 1.0));
                        this.backScratcher.getLookControl().setLookAt(this.backScratcher.getX() + lookAwayOffset.x(), this.backScratcher.getEyeY() + lookAwayOffset.y(), this.backScratcher.getZ() + lookAwayOffset.z(), 30.0f, (float)this.backScratcher.getMaxHeadXRot());
                    }
                }
            }
            if (!backScratching || stopScratchingBack) {
                if (DebugFlags.DEBUG_BACK_SCRATCH) {
                    BlastFromThePast.LOGGER.info("{} is no longer scratching their back at {}", this.backScratcher, (Object)above);
                }
                this.canScratchBack = false;
            }
        } else {
            if (this.backScratchCounter > 0) {
                BlastFromThePast.LOGGER.info("Forcibly stopping active back scratch animation for {}", this.backScratcher);
                ((BackScratcher)this.backScratcher).setBackScratching(false);
            }
            this.backScratcher.getLookControl().setLookAt(lookTarget.x(), lookTarget.y(), lookTarget.z(), 10.0f, (float)this.backScratcher.getMaxHeadXRot());
        }
    }

    protected boolean findNearestBlock() {
        boolean foundNearestBlock = super.findNearestBlock();
        if (foundNearestBlock && DebugFlags.DEBUG_BACK_SCRATCH) {
            BlastFromThePast.LOGGER.info("{} found a tree to scratch their back on!", this.backScratcher);
        }
        return foundNearestBlock;
    }

    protected boolean isValidTarget(LevelReader level, BlockPos pos) {
        boolean isTree = this.isTree(level, pos);
        if (isTree && this.wantsToScratchBack && !this.canScratchBack) {
            this.canScratchBack = true;
            if (DebugFlags.DEBUG_BACK_SCRATCH) {
                BlastFromThePast.LOGGER.info("{} can scratch their back on a tree!", this.backScratcher);
            }
            return true;
        }
        return false;
    }

    private boolean isTree(LevelReader level, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        boolean foundTree = false;
        for (int i = 0; i < 3; ++i) {
            mutable.move(Direction.UP);
            foundTree = this.isBackScratchBlock.test(level.getBlockState((BlockPos)mutable));
        }
        return foundTree;
    }

    public void stop() {
        super.stop();
        this.turning = false;
        if (this.backScratchCounter > 0) {
            this.backScratchCounter = 0;
        } else if (DebugFlags.DEBUG_BACK_SCRATCH) {
            BlastFromThePast.LOGGER.info("Prematurely ending scratch back behavior for {}", this.backScratcher);
        }
        ((BackScratcher)this.backScratcher).setBackScratching(false);
        ((BackScratcher)this.backScratcher).setPreparingToScratchBack(false);
    }
}

