/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.animal.Animal;
import team.recrafted.blastfromthepast.mixin.FollowParentGoalAccessor;
import team.recrafted.blastfromthepast.util.HitboxHelper;

public class HitboxAdjustedFollowParentGoal
extends FollowParentGoal {
    public HitboxAdjustedFollowParentGoal(Animal animal, double speedModifier) {
        super(animal, speedModifier);
    }

    public boolean canUse() {
        if (this.access().getAnimal().getAge() >= 0) {
            return false;
        }
        List potentialParents = this.access().getAnimal().level().getEntitiesOfClass(this.access().getAnimal().getClass(), this.access().getAnimal().getBoundingBox().inflate(8.0, 4.0, 8.0));
        Animal parent = null;
        double closestDistanceToSqr = Double.MAX_VALUE;
        for (Animal potentialParent : potentialParents) {
            double distanceToSqr;
            if (potentialParent.getAge() < 0 || (distanceToSqr = HitboxHelper.getDistSqrBetweenHitboxes((Entity)this.access().getAnimal(), (Entity)potentialParent)) > closestDistanceToSqr) continue;
            closestDistanceToSqr = distanceToSqr;
            parent = potentialParent;
        }
        if (parent == null) {
            return false;
        }
        if (closestDistanceToSqr < 9.0) {
            return false;
        }
        this.access().setParent(parent);
        return true;
    }

    private FollowParentGoalAccessor access() {
        return (FollowParentGoalAccessor)((Object)this);
    }

    public boolean canContinueToUse() {
        if (this.access().getAnimal().getAge() >= 0) {
            return false;
        }
        if (!this.access().getParent().isAlive()) {
            return false;
        }
        double distanceToSqr = HitboxHelper.getDistSqrBetweenHitboxes((Entity)this.access().getAnimal(), (Entity)this.access().getParent());
        return !(distanceToSqr < 9.0) && !(distanceToSqr > 256.0);
    }
}

