/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import team.recrafted.blastfromthepast.mixin.BreedGoalAccessor;
import team.recrafted.blastfromthepast.util.HitboxHelper;

public class HitboxAdjustedBreedGoal
extends BreedGoal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.forNonCombat().ignoreLineOfSight();
    protected boolean testInvisible = true;
    protected double range = 15.0;
    protected TargetingConditions partnerTargeting = PARTNER_TARGETING.copy();

    public HitboxAdjustedBreedGoal(Animal animal, double speedModifier) {
        this(animal, speedModifier, animal.getClass());
    }

    public HitboxAdjustedBreedGoal(Animal animal, double speedModifier, Class<? extends Animal> partnerClass) {
        super(animal, speedModifier, partnerClass);
        this.partnerTargeting.selector(this::isCloseEnoughToBreed);
    }

    protected boolean isCloseEnoughToBreed(LivingEntity target) {
        return HitboxHelper.isCloseEnoughForTargeting((LivingEntity)this.animal, target, this.testInvisible, this.range);
    }

    public boolean canUse() {
        if (!this.animal.isInLove()) {
            return false;
        }
        this.partner = this.findPartner();
        return this.partner != null;
    }

    public void tick() {
        this.animal.getLookControl().setLookAt((Entity)this.partner, 10.0f, (float)this.animal.getMaxHeadXRot());
        this.animal.getNavigation().moveTo((Entity)this.partner, this.access().getSpeedModifier());
        this.access().setLoveTime(this.access().getLoveTime() + 1);
        double distanceToPartnerSqr = HitboxHelper.getDistSqrBetweenHitboxes((Entity)this.animal, (Entity)this.partner);
        if (this.access().getLoveTime() >= this.adjustedTickDelay(60) && distanceToPartnerSqr < 13.0) {
            this.breed();
        }
    }

    @Nullable
    protected Animal findPartner() {
        List potentialPartners = this.level.getNearbyEntities(this.access().getPartnerClass(), this.partnerTargeting, (LivingEntity)this.animal, this.animal.getBoundingBox().inflate(this.range));
        double closestDistanceToSqr = Double.MAX_VALUE;
        Animal partner = null;
        for (Animal potentialPartner : potentialPartners) {
            if (!this.animal.canMate(potentialPartner) || potentialPartner.isPanicking() || !(this.animal.distanceToSqr((Entity)potentialPartner) < closestDistanceToSqr)) continue;
            partner = potentialPartner;
            closestDistanceToSqr = this.animal.distanceToSqr((Entity)potentialPartner);
        }
        return partner;
    }

    protected BreedGoalAccessor access() {
        return (BreedGoalAccessor)((Object)this);
    }
}

