/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;
import team.recrafted.blastfromthepast.entity.GlacerosEntity;

public class GlacerosSparGoal
extends Goal {
    private final GlacerosEntity glaceros;
    private GlacerosEntity targetGlaceros;
    private Path path;

    public GlacerosSparGoal(GlacerosEntity glaceros) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
        this.glaceros = glaceros;
    }

    public boolean canUse() {
        if (this.glaceros.isBaby() || this.glaceros.isPanicking() || this.glaceros.isSheared() || this.glaceros.sparringCooldown > 0) {
            return false;
        }
        if (this.glaceros.shouldSparInstantly || this.glaceros.getRandom().nextInt(200) == 0) {
            this.glaceros.shouldSparInstantly = false;
            if (this.glaceros.getSparringPartner() instanceof GlacerosEntity) {
                this.targetGlaceros = (GlacerosEntity)this.glaceros.getSparringPartner();
                this.path = this.glaceros.getNavigation().createPath((Entity)this.targetGlaceros, 0);
                if (this.path == null || !this.path.canReach()) {
                    return false;
                }
                return this.targetGlaceros.sparringCooldown == 0;
            }
            GlacerosEntity possiblePartner = this.getNearbyGlacerosForSparring();
            if (possiblePartner != null) {
                this.glaceros.setSparringPartner((Entity)possiblePartner);
                possiblePartner.setSparringPartner((Entity)this.glaceros);
                this.targetGlaceros = possiblePartner;
                this.targetGlaceros.shouldSparInstantly = true;
                this.path = this.glaceros.getNavigation().createPath((Entity)this.targetGlaceros, 0);
                return this.path != null && this.path.canReach();
            }
        }
        return false;
    }

    public void start() {
        super.start();
        this.glaceros.chargeTimer = 0;
        this.glaceros.setRushing(false);
    }

    public void stop() {
        super.stop();
        this.glaceros.setCharging(false);
        this.glaceros.setRushing(false);
        this.glaceros.chargeTimer = 0;
        this.glaceros.getNavigation().stop();
        this.glaceros.sparringCooldown = this.generateSparCooldown(this.glaceros);
        if (this.targetGlaceros != null) {
            this.targetGlaceros.setCharging(false);
            this.targetGlaceros.setRushing(false);
            this.targetGlaceros.chargeTimer = 0;
            this.targetGlaceros.getNavigation().stop();
            this.targetGlaceros.sparringCooldown = this.generateSparCooldown(this.targetGlaceros);
        }
    }

    public void tick() {
        super.tick();
        if (this.targetGlaceros != null) {
            this.glaceros.getLookControl().setLookAt((Entity)this.targetGlaceros);
            this.targetGlaceros.getLookControl().setLookAt((Entity)this.glaceros);
            this.glaceros.setCharging(true);
            this.targetGlaceros.setCharging(true);
            ++this.glaceros.chargeTimer;
            ++this.targetGlaceros.chargeTimer;
            if (this.glaceros.chargeTimer > 100 || this.targetGlaceros.chargeTimer > 100) {
                this.glaceros.setRushing(true);
                this.targetGlaceros.setRushing(true);
                this.glaceros.setCharging(false);
                this.targetGlaceros.setCharging(false);
                this.glaceros.hasImpulse = true;
                if ((double)this.glaceros.distanceTo((Entity)this.targetGlaceros) > 1.5) {
                    this.glaceros.getNavigation().moveTo((Entity)this.targetGlaceros, 2.5);
                    this.targetGlaceros.getNavigation().moveTo((Entity)this.glaceros, 2.5);
                } else {
                    if (this.glaceros.onGround()) {
                        this.glaceros.knockBackSparring(this.targetGlaceros, 1.25f);
                    }
                    if (this.targetGlaceros.onGround()) {
                        this.targetGlaceros.knockBackSparring(this.glaceros, 1.25f);
                    }
                    this.glaceros.chargeTimer = 0;
                    this.glaceros.sparringCooldown = this.generateSparCooldown(this.glaceros);
                    this.targetGlaceros.chargeTimer = 0;
                    this.targetGlaceros.sparringCooldown = this.generateSparCooldown(this.targetGlaceros);
                    this.stop();
                }
            }
        }
    }

    public boolean canContinueToUse() {
        if (this.targetGlaceros != null) {
            this.path = this.glaceros.getNavigation().createPath((Entity)this.targetGlaceros, 0);
            if (this.path == null || !this.path.canReach()) {
                return false;
            }
        }
        return !this.glaceros.isBaby() && !this.glaceros.isSheared() && !this.glaceros.isPanicking() && !this.targetGlaceros.isPanicking() && this.targetGlaceros != null && !this.targetGlaceros.isSheared() && this.targetGlaceros.isAlive() && this.targetGlaceros.sparringCooldown == 0 && this.glaceros.sparringCooldown == 0;
    }

    public boolean isInterruptable() {
        return false;
    }

    @Nullable
    private GlacerosEntity getNearbyGlacerosForSparring() {
        List listOfGlaceros = this.glaceros.level().getEntitiesOfClass(GlacerosEntity.class, this.glaceros.getBoundingBox().inflate(10.0));
        double lvt_2_1_ = 100.0;
        GlacerosEntity nearbyGlaceros = null;
        for (GlacerosEntity glacerosEntity : listOfGlaceros) {
            if (this.glaceros == glacerosEntity || !this.glaceros.canSparWith(glacerosEntity) || !(this.glaceros.distanceToSqr((Entity)glacerosEntity) < lvt_2_1_) || !(this.glaceros.distanceToSqr((Entity)glacerosEntity) > 6.0)) continue;
            nearbyGlaceros = glacerosEntity;
            lvt_2_1_ = this.glaceros.distanceToSqr((Entity)glacerosEntity);
        }
        return nearbyGlaceros;
    }

    private int generateSparCooldown(GlacerosEntity entity) {
        return 400 + entity.getRandom().nextInt(100);
    }
}

