/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity;

import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModItems;

public class TarArrow
extends AbstractArrow {
    public static final int MAX_TICKS_THROUGH_BLOCKS = 2;
    private int getMaxTicksThroughBlocks = 2;

    public TarArrow(double x, double y, double z, Level level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super((EntityType)ModEntities.TAR_ARROW.get(), x, y, z, level, pickupItemStack, firedFromWeapon);
    }

    public TarArrow(EntityType<? extends TarArrow> entityEntityType, Level level) {
        super(entityEntityType, level);
    }

    public TarArrow(Level level, LivingEntity shooter, ItemStack itemStack, ItemStack weapon) {
        super((EntityType)ModEntities.TAR_ARROW.get(), shooter, level, itemStack, weapon);
    }

    @NotNull
    protected ProjectileDeflection hitTargetOrDeflectSelf(HitResult hitResult) {
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            return ProjectileDeflection.NONE;
        }
        return super.hitTargetOrDeflectSelf(hitResult);
    }

    protected ItemStack getDefaultPickupItem() {
        return ModItems.TAR_ARROW.toStack();
    }

    public void tick() {
        this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.1), EntitySelector.NO_SPECTATORS.and(x$0 -> this.canHitEntity((Entity)x$0))).stream().findFirst().ifPresent(entity -> {
            if (entity != this) {
                this.onHitEntity(new EntityHitResult(entity));
                this.discard();
            }
        });
        if (!this.isRemoved()) {
            super.tick();
        }
    }

    public void setInGround(boolean inGround) {
        this.inGround = inGround;
        this.hasImpulse = true;
    }

    public boolean canPhaseThroughBlocks() {
        return this.getMaxTicksThroughBlocks > 0;
    }

    public void tickPhasing() {
        --this.getMaxTicksThroughBlocks;
    }
}

