/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import team.recrafted.blastfromthepast.entity.ai.goal.SnowdoBreedGoal;
import team.recrafted.blastfromthepast.init.ModCriteriaTriggers;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModItems;
import team.recrafted.blastfromthepast.init.ModSounds;

public class SnowdoEntity
extends Animal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> TRIPPED = SynchedEntityData.defineId(SnowdoEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Optional<UUID>> RIDDEN_PLAYER = SynchedEntityData.defineId(SnowdoEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public static final EntityDataAccessor<Boolean> GLIDING = SynchedEntityData.defineId(SnowdoEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_SHEARED = SynchedEntityData.defineId(SnowdoEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final float movementSpeed = 0.12f;
    public int tripTicks;
    public int featherGrowthTimer;
    private boolean party;
    @javax.annotation.Nullable
    private BlockPos jukebox;
    public static final RawAnimation IDLE = RawAnimation.begin().then("animation.snowdo.idle", Animation.LoopType.DEFAULT);
    public static final RawAnimation TRIP = RawAnimation.begin().then("animation.snowdo.trip", Animation.LoopType.DEFAULT);
    public static final RawAnimation GLIDE = RawAnimation.begin().then("animation.snowdo.glide", Animation.LoopType.DEFAULT);
    public static final RawAnimation TAIL = RawAnimation.begin().then("animation.snowdo.tail", Animation.LoopType.DEFAULT);
    public static final RawAnimation WALK = RawAnimation.begin().then("animation.snowdo.walk", Animation.LoopType.DEFAULT);
    public static final RawAnimation DANCE = RawAnimation.begin().then("animation.snowdo.dance", Animation.LoopType.DEFAULT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SnowdoEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 2;
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createMobAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.12f).add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    public void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SnowdoBreedGoal(this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, stack -> stack.is(ModItems.MELON_ICE_CREAM), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void aiStep() {
        if (this.jukebox == null || !this.jukebox.closerToCenterThan((Position)this.position(), 7.0) || !this.level().getBlockState(this.jukebox).is(Blocks.JUKEBOX)) {
            this.party = false;
            this.jukebox = null;
        }
        super.aiStep();
    }

    public void setRecordPlayingNearby(BlockPos pos, boolean isPartying) {
        this.jukebox = pos;
        if (!this.level().isClientSide && isPartying && this.jukebox != null && this.jukebox.closerToCenterThan((Position)this.position(), 15.0) && this.level().getBlockState(this.jukebox).is(Blocks.JUKEBOX)) {
            this.level().getEntitiesOfClass(Player.class, this.getHitbox().inflate(10.0)).forEach(player -> ModCriteriaTriggers.DANCE_TRIGGER.trigger((ServerPlayer)player, this));
        }
    }

    public void setTripped(boolean tripped) {
        this.entityData.set(TRIPPED, (Object)tripped);
        if (tripped) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
            this.tripTicks = 30;
        } else {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue((double)0.12f);
            this.tripTicks = 0;
        }
    }

    public boolean isTripped() {
        return (Boolean)this.entityData.get(TRIPPED);
    }

    public void setGliding(boolean isGliding) {
        this.entityData.set(GLIDING, (Object)isGliding);
    }

    public boolean isGliding() {
        return (Boolean)this.entityData.get(GLIDING);
    }

    public boolean isSheared() {
        return (Boolean)this.entityData.get(IS_SHEARED);
    }

    public void setSheared(boolean sheared) {
        if (sheared) {
            this.featherGrowthTimer = 2400;
        }
        this.entityData.set(IS_SHEARED, (Object)sheared);
    }

    public void setRiddenPlayer(Optional<UUID> uuid) {
        this.entityData.set(RIDDEN_PLAYER, uuid);
    }

    public Optional<UUID> getRiddenPlayer() {
        return (Optional)this.entityData.get(RIDDEN_PLAYER);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TRIPPED, (Object)false);
        builder.define(RIDDEN_PLAYER, Optional.empty());
        builder.define(GLIDING, (Object)false);
        builder.define(IS_SHEARED, (Object)false);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isBaby() ? EntityDimensions.fixed((float)0.35f, (float)0.35f).withEyeHeight(0.2f) : super.getDefaultDimensions(pose);
    }

    public boolean hurt(DamageSource source, float amount) {
        this.jukebox = null;
        this.party = false;
        return super.hurt(source, amount);
    }

    public void tick() {
        Player player;
        super.tick();
        if (this.getVehicle() instanceof Player && this.isInWaterOrBubble()) {
            this.stopRiding();
            this.setRiddenPlayer(Optional.empty());
        }
        if (this.getVehicle() == null) {
            Vec3 vec3 = this.getDeltaMovement();
            if (!this.onGround() && vec3.y < 0.0) {
                this.setDeltaMovement(vec3.multiply(1.0, 0.6, 1.0));
            }
        }
        if (!this.level().isClientSide()) {
            if (this.featherGrowthTimer > 0) {
                --this.featherGrowthTimer;
                if (this.featherGrowthTimer == 0) {
                    this.setSheared(false);
                }
            }
            if (this.getRandom().nextInt(500) == 0 && this.getDeltaMovement().horizontalDistanceSqr() > 1.0E-6 && this.onGround() && !this.isPassenger()) {
                this.setTripped(true);
                this.level().playSound(null, this.blockPosition(), (SoundEvent)ModSounds.SNOWDO_TRIP.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            }
            if (this.isTripped()) {
                --this.tripTicks;
            }
            if (this.tripTicks <= 0) {
                this.setTripped(false);
            }
            if (this.isPassenger() && !this.getVehicle().onGround() || !this.isPassenger() && !this.onGround()) {
                this.setGliding(true);
            } else if (this.isGliding()) {
                this.setGliding(false);
            }
            Entity entity = this.getVehicle();
            if (entity instanceof Player) {
                player = (Player)entity;
                this.setRot(player.getYRot(), player.getXRot() * 0.5f);
                this.yRotO = this.yBodyRot = this.getYRot();
                Vec3 vec3 = player.getDeltaMovement();
                if (!player.onGround() && vec3.y < 0.0) {
                    player.setDeltaMovement(vec3.multiply(1.0, 0.6, 1.0));
                    player.hurtMarked = true;
                    player.resetFallDistance();
                }
            }
        }
        Player player2 = player = this.getRiddenPlayer().isPresent() ? this.level().getPlayerByUUID(this.getRiddenPlayer().get()) : null;
        if (!(this.getVehicle() instanceof Player) && this.getRiddenPlayer().isPresent() && player != null && !player.isCrouching()) {
            this.startRiding((Entity)player);
        }
        if (player == null || player.isCrouching()) {
            this.stopRiding();
            this.setRiddenPlayer(Optional.empty());
        }
        if (this.getRandom().nextInt(100) == 0 && !this.isBaby()) {
            this.triggerAnim("second", "tail");
        }
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        if (this.isGliding()) {
            return false;
        }
        return super.causeFallDamage(fallDistance, multiplier, source);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (player.getMainHandItem().isEmpty() && !this.isBaby() && player.getFirstPassenger() == null) {
            this.startRiding((Entity)player, true);
            this.setRiddenPlayer(Optional.of(player.getUUID()));
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (player.getMainHandItem().getItem() == Items.SHEARS && this.featherGrowthTimer == 0) {
            this.level().playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.setSheared(true);
            this.spawnAtLocation(new ItemStack((ItemLike)Items.FEATHER, this.random.nextIntBetweenInclusive(1, 3)));
        }
        return super.mobInteract(player, hand);
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)ModSounds.SNOWDO_HURT.get();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.SNOWDO_IDLE.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.SNOWDO_DEATH.get();
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ModItems.MELON_ICE_CREAM);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return (AgeableMob)((EntityType)ModEntities.SNOWDO.get()).create((Level)level);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setTripped(compound.getBoolean("tripped"));
        this.tripTicks = compound.getInt("tripTicks");
        if (compound.contains("RiddenPlayer")) {
            this.setRiddenPlayer(Optional.of(compound.getUUID("RiddenPlayer")));
        }
        this.setSheared(compound.getBoolean("sheared"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("tripped", this.isTripped());
        compound.putInt("tripTicks", this.tripTicks);
        if (this.getRiddenPlayer().isPresent()) {
            compound.putUUID("RiddenPlayer", this.getRiddenPlayer().get());
        }
        compound.putBoolean("sheared", this.isSheared());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 5, state -> {
            if (this.isTripped()) {
                return state.setAndContinue(TRIP);
            }
            if (!this.isBaby() && this.isGliding()) {
                return state.setAndContinue(GLIDE);
            }
            if (state.isMoving()) {
                return state.setAndContinue(WALK);
            }
            if (this.party && !this.isBaby()) {
                return state.setAndContinue(DANCE);
            }
            return state.setAndContinue(IDLE);
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "second", 0, state -> PlayState.STOP).triggerableAnim("tail", TAIL));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

