/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.datagen.server;

import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.recrafted.blastfromthepast.init.ModBlocks;

public class ModBlockLootGen
extends BlockLootSubProvider {
    protected ModBlockLootGen(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected Iterable<Block> getKnownBlocks() {
        return ModBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).filter(block -> block != ModBlocks.PERMAFROST.BLOCK.get() && block != ModBlocks.PSYCHO_BERRY_BUSH.get() && block != ModBlocks.PSYCHO_BERRY_SPROUT.get()).collect(Collectors.toSet());
    }

    protected void generate() {
        for (DeferredHolder block : ModBlocks.BLOCKS.getEntries()) {
            this.makeBlockDropItself((Block)block.get());
        }
    }

    protected void makeBlockDropItself(Block block) {
        if (block != ModBlocks.PERMAFROST.BLOCK.get() && block != ModBlocks.PSYCHO_BERRY_BUSH.get() && block != ModBlocks.PSYCHO_BERRY_SPROUT.get()) {
            this.add(block, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block.asItem()))));
        }
    }
}

