/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.datagen.client;

import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import team.recrafted.blastfromthepast.block.BFTPBlockGroup;
import team.recrafted.blastfromthepast.block.BFTPStoneGroup;
import team.recrafted.blastfromthepast.block.BFTPWoodGroup;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModItems;

public class ModItemModelGen
extends ItemModelProvider {
    public ModItemModelGen(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "blastfromthepast", existingFileHelper);
    }

    protected void registerModels() {
        this.basicItem((Item)ModItems.BLIZZARD_REVELRY_DISC.get());
        this.basicItem((Item)ModItems.RAW_VENISON.get());
        this.basicItem((Item)ModItems.SAP_BALL.get());
        this.basicItem((Item)ModItems.COOKED_VENISON.get());
        this.basicItem((Item)ModItems.STRAIGHT_GLACEROS_ANTLERS.get());
        this.basicItem((Item)ModItems.BROAD_GLACEROS_ANTLERS.get());
        this.basicItem((Item)ModItems.SPIKEY_GLACEROS_ANTLERS.get());
        this.basicItem((Item)ModItems.CURLY_GLACEROS_ANTLERS.get());
        this.basicItem((Item)ModItems.BEAST_POTTERY_SHERD.get());
        this.basicItem((Item)ModItems.WOODS_POTTERY_SHERD.get());
        this.basicItem((Item)ModItems.FROST_POTTERY_SHERD.get());
        this.withExistingParent(ModItems.SNOWDO_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.GLACEROS_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.FROSTOMPER_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.PSYCHO_BEAR_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.BURREL_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.SPEARTOOTH_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
        this.basicItem((Item)ModItems.CEDAR_BOAT.get());
        this.basicItem((Item)ModItems.CEDAR_CHEST_BOAT.get());
        this.basicItem((Item)ModItems.PSYCHO_BERRY.get());
        this.basicItem((Item)ModItems.SAP_ICE_CREAM.get());
        this.basicItem((Item)ModItems.PSYCHO_BERRY_ICE_CREAM.get());
        this.basicItem((Item)ModItems.MELON_ICE_CREAM.get());
        this.basicItem((Item)ModItems.SCHRODINGERS_ICE_CREAM.get());
        this.basicItem((Item)ModItems.BEAR_CLAW.get());
        this.basicItem((Item)ModItems.SHAGGY_PELT.get());
        this.basicItem((Item)ModItems.IDOL_OF_RETRIEVAL.get());
        this.basicItem((Item)ModItems.GLACIAL_GUIDEBOOK.get());
        this.basicItem((Item)ModItems.FROST_BITE_HELMET.get());
        this.basicItem((Item)ModItems.FROST_BITE_BOOTS.get());
        this.basicItem((Item)ModItems.FROST_BITE_CHESTPLATE.get());
        this.basicItem((Item)ModItems.FROST_BITE_LEGGINGS.get());
        this.registerWoodGroup(ModBlocks.CEDAR);
        this.registerStoneGroup(ModBlocks.PERMAFROST);
        this.createWithParent(ModBlocks.SAPPY_CEDAR_LOG);
        this.singleTextureDoublePlantBlock(ModBlocks.ROYAL_LARKSPUR, true);
        this.singleTextureDoublePlantBlock(ModBlocks.SHIVER_LARKSPUR, true);
        this.singleTextureDoublePlantBlock(ModBlocks.SNOW_LARKSPUR, true);
        this.singleTextureDoublePlantBlock(ModBlocks.BLUSH_LARKSPUR, true);
        this.withExistingParent(ModBlocks.BEASTLY_FEMUR.getId().getPath(), this.modLoc("block/femur"));
        this.withExistingParent(ModBlocks.PSYCHO_BERRY_BUSH.getId().getPath(), this.modLoc("block/psycho_berry_bush"));
        this.singleTexturePlantBlock(ModBlocks.PSYCHO_BERRY_SPROUT);
        this.singleTextureBlock(ModBlocks.SNOWDO_EGG);
        this.createWithParent(ModBlocks.TAR);
        this.registerBlockGroup(ModBlocks.SNOW_BRICK);
        this.registerBlockGroup(ModBlocks.ICE_BRICK);
        this.singleTexturePlantBlock(ModBlocks.SILENE);
        this.createWithParent(ModBlocks.CHILLY_MOSS);
        this.createWithCutoutParent(ModBlocks.CHILLY_MOSS_SPROUT);
        this.createWithParent(ModBlocks.PERMAFROST_BURREL_PAINTING);
        this.createWithParent(ModBlocks.PERMAFROST_SNOWDO_PAINTING);
        this.createWithParent(ModBlocks.PERMAFROST_GLACEROS_PAINTING);
        this.createWithParent(ModBlocks.PERMAFROST_PSYCHO_BEAR_PAINTING);
        this.createWithParent(ModBlocks.PERMAFROST_SPEARTOOTH_PAINTING);
        this.createWithParent(ModBlocks.PERMAFROST_FROSTOMPER_PAINTING_TOP_RIGHT);
        this.createWithParent(ModBlocks.PERMAFROST_FROSTOMPER_PAINTING_TOP_LEFT);
        this.createWithParent(ModBlocks.PERMAFROST_FROSTOMPER_PAINTING_BOTTOM_RIGHT);
        this.createWithParent(ModBlocks.PERMAFROST_FROSTOMPER_PAINTING_BOTTOM_LEFT);
    }

    private void registerStoneGroup(BFTPStoneGroup stoneGroup) {
        this.createWithParent(stoneGroup.BLOCK);
        this.createWithParent(stoneGroup.STAIRS);
        this.createWithParent(stoneGroup.SLAB);
        ((ItemModelBuilder)this.withExistingParent(stoneGroup.WALL.getId().getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", this.modLoc("block/" + stoneGroup.WALL.getId().getPath().replaceAll("_wall", "")));
        this.createWithParent(stoneGroup.CHISELED_BRICKS);
        this.createWithParent(stoneGroup.BRICKS);
        this.createWithParent(stoneGroup.BRICKS_STAIRS);
        this.createWithParent(stoneGroup.BRICKS_SLAB);
        ((ItemModelBuilder)this.withExistingParent(stoneGroup.BRICKS_WALL.getId().getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", this.modLoc("block/" + stoneGroup.BRICKS_WALL.getId().getPath().replaceAll("_wall", "")));
        this.createWithParent(stoneGroup.POLISHED);
        this.createWithParent(stoneGroup.POLISHED_STAIRS);
        this.createWithParent(stoneGroup.POLISHED_SLAB);
        ((ItemModelBuilder)this.withExistingParent(stoneGroup.POLISHED_WALL.getId().getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", this.modLoc("block/" + stoneGroup.POLISHED_WALL.getId().getPath().replaceAll("_wall", "")));
        this.createWithParent(stoneGroup.COBBLESTONE);
        this.createWithParent(stoneGroup.COBBLESTONE_STAIRS);
        this.createWithParent(stoneGroup.COBBLESTONE_SLAB);
        ((ItemModelBuilder)this.withExistingParent(stoneGroup.COBBLESTONE_WALL.getId().getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", this.modLoc("block/" + stoneGroup.COBBLESTONE_WALL.getId().getPath().replaceAll("_wall", "")));
        for (DeferredBlock<?> block : stoneGroup.blocks) {
            if (!block.getId().getPath().contains("ore")) continue;
            this.createWithParent(block);
        }
    }

    private void registerWoodGroup(BFTPWoodGroup woodGroup) {
        this.createWithParent(woodGroup.BLOCK);
        this.createWithParent(woodGroup.LOG);
        this.createWithParent(woodGroup.STRIPPED_LOG);
        this.createWithParent(woodGroup.WOOD);
        this.createWithParent(woodGroup.STRIPPED_WOOD);
        this.createWithParent(woodGroup.SLAB);
        this.createWithParent(woodGroup.STAIRS);
        this.createWithParent(woodGroup.LEAVES);
        this.createSuffixedParent(woodGroup.FENCE, "_inventory");
        this.createWithParent(woodGroup.FENCE_GATE);
        this.createWithParent(woodGroup.PRESSURE_PLATE);
        this.createSuffixedParent(woodGroup.BUTTON, "_inventory");
        this.withExistingParent(woodGroup.TRAPDOOR.getId().getPath(), this.modLoc("block/" + woodGroup.BLOCK.getId().getPath() + "_trapdoor_bottom"));
        this.singleTextureBlock(woodGroup.DOOR);
        this.basicItem((Item)woodGroup.SIGN_ITEM.get());
        this.basicItem((Item)woodGroup.HANGING_SIGN_ITEM.get());
    }

    private void registerBlockGroup(BFTPBlockGroup blockGroup) {
        this.createWithParent(blockGroup.BLOCK);
        this.createWithParent(blockGroup.STAIRS);
        this.createWithParent(blockGroup.SLAB);
        ((ItemModelBuilder)this.withExistingParent(blockGroup.WALL.getId().getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", this.modLoc("block/" + blockGroup.WALL.getId().getPath().replaceAll("_wall", "")));
    }

    private void createWithParent(DeferredBlock<? extends Block> key) {
        this.withExistingParent(key.getId().getPath(), this.modLoc("block/" + key.getId().getPath()));
    }

    private void createWithCutoutParent(DeferredBlock<? extends Block> key) {
        ((ItemModelBuilder)this.withExistingParent(key.getId().getPath(), this.modLoc("block/" + key.getId().getPath()))).renderType("cutout_mipped");
    }

    private void singleTextureBlock(DeferredBlock<? extends Block> key) {
        ((ItemModelBuilder)this.singleTexture(key.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + key.getId().getPath()))).renderType("cutout_mipped");
    }

    private void singleTexturePlantBlock(DeferredBlock<? extends Block> key) {
        ((ItemModelBuilder)this.singleTexture(key.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("block/" + key.getId().getPath()))).renderType("cutout_mipped");
    }

    private void createSuffixedParent(DeferredBlock<? extends Block> handler, String suffix) {
        this.withExistingParent(handler.getId().getPath(), this.modLoc("block/" + handler.getId().getPath() + suffix));
    }

    private void singleTextureDoublePlantBlock(DeferredBlock<Block> block, boolean isTop) {
        this.singleTexture(block.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("block/" + block.getId().getPath() + (isTop ? "_top" : "_bottom")));
    }
}

