/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.client.screen;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import team.recrafted.blastfromthepast.BlastFromThePast;

public class GlacialGuidebookScreen
extends Screen {
    private PageButton forwardButton;
    private PageButton backButton;
    private int currentPage;
    private final int pageCount = 6;
    public static final ResourceLocation BOOK_LOCATION = BlastFromThePast.location("textures/gui/glacial_guidebook/glacial_guidebook_inside.png");
    public static final ResourceLocation BURREL = BlastFromThePast.location("textures/gui/glacial_guidebook/glacial_guidebook_burrel.png");
    public static final ResourceLocation FROSTOMPER = BlastFromThePast.location("textures/gui/glacial_guidebook/glacial_guidebook_frostomper.png");
    public static final ResourceLocation GLACEROS = BlastFromThePast.location("textures/gui/glacial_guidebook/glacial_guidebook_glaceros.png");
    public static final ResourceLocation PSYCHO_BEAR = BlastFromThePast.location("textures/gui/glacial_guidebook/glacial_guidebook_psycho_bear.png");
    public static final ResourceLocation SNOWDO = BlastFromThePast.location("textures/gui/glacial_guidebook/glacial_guidebook_snowdo.png");
    public static final ResourceLocation SPEARTOOTH = BlastFromThePast.location("textures/gui/glacial_guidebook/glacial_guidebook_speartooth.png");

    public GlacialGuidebookScreen() {
        super((Component)Component.literal((String)"screen.blastfromthepast.glacial_guidebook"));
    }

    public boolean setPage(int pageNum) {
        int i = Mth.clamp((int)pageNum, (int)0, (int)5);
        if (i != this.currentPage) {
            this.currentPage = i;
            this.updateButtonVisibility();
            return true;
        }
        return false;
    }

    protected boolean forcePage(int pageNum) {
        return this.setPage(pageNum);
    }

    protected void init() {
        this.createMenuControls();
        this.createPageControlButtons();
    }

    protected void createMenuControls() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, p_315823_ -> this.onClose()).bounds(this.width / 2 - 100, 196, 200, 20).build());
    }

    protected void createPageControlButtons() {
        int i = (this.width - 192) / 2;
        this.forwardButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(i + 116, 155, true, p_98297_ -> this.pageForward(), true));
        this.backButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(i + 43, 155, false, p_98287_ -> this.pageBack(), true));
        this.updateButtonVisibility();
    }

    protected void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        this.updateButtonVisibility();
    }

    protected void pageForward() {
        if (this.currentPage < 5) {
            ++this.currentPage;
        }
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        this.forwardButton.visible = this.currentPage < 5;
        this.backButton.visible = this.currentPage > 0;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        switch (keyCode) {
            case 266: {
                this.backButton.onPress();
                return true;
            }
            case 267: {
                this.forwardButton.onPress();
                return true;
            }
        }
        return false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int x = (this.width - 192) / 2 - 29;
        int xOffset = this.currentPage % 2 == 0 ? 120 : 0;
        int xOffset2 = this.currentPage % 2 == 0 ? 0 : 120;
        ResourceLocation mob = FROSTOMPER;
        switch (this.currentPage) {
            case 0: {
                mob = BURREL;
                break;
            }
            case 1: {
                mob = SNOWDO;
                break;
            }
            case 2: {
                mob = GLACEROS;
                break;
            }
            case 3: {
                mob = SPEARTOOTH;
                break;
            }
            case 4: {
                mob = PSYCHO_BEAR;
            }
        }
        guiGraphics.blit(mob, x, 20, 0.0f, 0.0f, 250, 156, 250, 156);
        MutableComponent component = switch (this.currentPage) {
            case 0 -> Component.translatable((String)"glacial_guidebook.burrel");
            case 1 -> Component.translatable((String)"glacial_guidebook.snowdo");
            case 2 -> Component.translatable((String)"glacial_guidebook.glaceros");
            case 3 -> Component.translatable((String)"glacial_guidebook.speartooth");
            case 4 -> Component.translatable((String)"glacial_guidebook.psycho_bear");
            default -> Component.translatable((String)"glacial_guidebook.frostomper");
        };
        MutableComponent title = switch (this.currentPage) {
            case 0 -> Component.translatable((String)"entity.blastfromthepast.burrel");
            case 1 -> Component.translatable((String)"entity.blastfromthepast.snowdo");
            case 2 -> Component.translatable((String)"entity.blastfromthepast.glaceros");
            case 3 -> Component.translatable((String)"entity.blastfromthepast.speartooth");
            case 4 -> Component.translatable((String)"entity.blastfromthepast.psycho_bear");
            default -> Component.translatable((String)"entity.blastfromthepast.frostomper");
        };
        int hp = 0;
        switch (this.currentPage) {
            case 0: {
                hp = 6;
                break;
            }
            case 1: {
                hp = 10;
                break;
            }
            case 2: {
                hp = 20;
                break;
            }
            case 3: {
                hp = 30;
                break;
            }
            case 4: {
                hp = 70;
                break;
            }
            default: {
                hp = 100;
            }
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(1.75f, 1.75f, 1.75f);
        guiGraphics.drawString(this.font, title.getString(), (float)(x + xOffset2 + 9) / 1.75f, 50.0f, 0, false);
        guiGraphics.pose().popPose();
        String type = this.currentPage < 3 ? Component.translatable((String)"glacial_guidebook.passive").getString() : (this.currentPage != 5 ? Component.translatable((String)"glacial_guidebook.hostile").getString() : Component.translatable((String)"glacial_guidebook.neutral").getString());
        guiGraphics.drawString(this.font, type, x + xOffset2 + 9, 104, 0x555555, false);
        guiGraphics.drawString(this.font, hp + " HP", x + xOffset2 + 9, 112, 0x555555, false);
        if (this.currentPage == 3 || this.currentPage == 5) {
            guiGraphics.drawString(this.font, Component.translatable((String)"glacial_guidebook.tamable").getString(), x + xOffset2 + 9, 120, 0x555555, false);
        }
        List list = this.font.split(FormattedText.of((String)component.getString()), this.currentPage <= 4 ? 110 : 129);
        float offset = x + xOffset + 9;
        if (this.currentPage > 4) {
            offset *= 1.176f;
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(0.85f, 0.85f, 0.85f);
        }
        for (int l = 0; l < list.size(); ++l) {
            FormattedCharSequence formattedcharsequence = (FormattedCharSequence)list.get(l);
            guiGraphics.drawString(this.font, formattedcharsequence, offset, (float)(30 + (this.currentPage > 4 ? 10 : 0) + l * 9), 0, false);
        }
        if (this.currentPage > 4) {
            guiGraphics.pose().popPose();
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(BOOK_LOCATION, (this.width - 192) / 2 - 29, 22, 0.0f, 0.0f, 250, 156, 250, 156);
    }

    public boolean handleComponentClicked(Style style) {
        ClickEvent clickevent = style.getClickEvent();
        if (clickevent == null) {
            return false;
        }
        if (clickevent.getAction() == ClickEvent.Action.CHANGE_PAGE) {
            String s = clickevent.getValue();
            try {
                int i = Integer.parseInt(s) - 1;
                return this.forcePage(i);
            }
            catch (Exception var5) {
                return false;
            }
        }
        boolean flag = super.handleComponentClicked(style);
        if (flag && clickevent.getAction() == ClickEvent.Action.RUN_COMMAND) {
            this.closeScreen();
        }
        return flag;
    }

    protected void closeScreen() {
        this.minecraft.setScreen(null);
    }
}

