/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.client.models.entity;

import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.speartooth.SpeartoothEntity;

public class SpeartoothModel
extends GeoModel<SpeartoothEntity> {
    public static final ResourceLocation MODEL = BlastFromThePast.location("geo/entity/speartooth.geo.json");
    public static final ResourceLocation BABY_MODEL = BlastFromThePast.location("geo/entity/baby_speartooth.geo.json");
    public static final ResourceLocation ANIMATION = BlastFromThePast.location("animations/entity/speartooth.animation.json");
    public static final ResourceLocation BABY_ANIMATION = BlastFromThePast.location("animations/entity/baby_speartooth.animation.json");

    public ResourceLocation getModelResource(SpeartoothEntity animatable) {
        if (animatable.isBaby()) {
            return BABY_MODEL;
        }
        return MODEL;
    }

    public ResourceLocation getTextureResource(SpeartoothEntity animatable) {
        return animatable.getTexture().textureId(animatable.isBaby());
    }

    public ResourceLocation getAnimationResource(SpeartoothEntity animatable) {
        if (animatable.isBaby()) {
            return BABY_ANIMATION;
        }
        return ANIMATION;
    }

    public void setCustomAnimations(SpeartoothEntity pEntity, long instanceId, AnimationState<SpeartoothEntity> animationState) {
        if (!pEntity.isSleeping()) {
            Optional head = this.getBone("mane");
            if (head.isEmpty()) {
                head = this.getBone("head");
            }
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            ((GeoBone)head.get()).setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            ((GeoBone)head.get()).setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

