/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.client.models.entity;

import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.client.ClientResourceHelper;
import team.recrafted.blastfromthepast.entity.PsychoBearEntity;
import team.recrafted.blastfromthepast.init.ModEntities;

public class PsychoBearModel
extends GeoModel<PsychoBearEntity> {
    public static final ResourceLocation MODEL = BlastFromThePast.location("geo/entity/psycho_bear.geo.json");
    public static final ResourceLocation BABY_MODEL = BlastFromThePast.location("geo/entity/baby_psycho_bear.geo.json");
    public static final ResourceLocation ANIMATION = BlastFromThePast.location("animations/entity/psycho_bear.animation.json");
    public static final ResourceLocation BABY_ANIMATION = BlastFromThePast.location("animations/entity/baby_psycho_bear.animation.json");
    private static final ResourceLocation BERRY_TEXTURE = ClientResourceHelper.entityTecLocWithTypeSubFolderWithSuffix(ModEntities.PSYCHO_BEAR.getId(), "_berry");
    private static final ResourceLocation BERRY_SLEEP_TEXTURE = ClientResourceHelper.entityTecLocWithTypeSubFolderWithSuffix(ModEntities.PSYCHO_BEAR.getId(), "_berry_sleep");
    private static final ResourceLocation BERRY_PACIFIED_TEXTURE = ClientResourceHelper.entityTecLocWithTypeSubFolderWithSuffix(ModEntities.PSYCHO_BEAR.getId(), "_berry_pacified");
    private static final ResourceLocation BERRY_PACIFIED_SLEEP_TEXTURE = ClientResourceHelper.entityTecLocWithTypeSubFolderWithSuffix(ModEntities.PSYCHO_BEAR.getId(), "_berry_pacified_sleep");
    private static final ResourceLocation BABY_TEXTURE = ClientResourceHelper.entityTexLocWithTypeSubFolderWithPrefix(ModEntities.PSYCHO_BEAR.getId(), "baby_");

    public ResourceLocation getModelResource(PsychoBearEntity animatable) {
        if (animatable.isBaby()) {
            return BABY_MODEL;
        }
        return MODEL;
    }

    public ResourceLocation getTextureResource(PsychoBearEntity animatable) {
        if (animatable.isBaby()) {
            return BABY_TEXTURE;
        }
        if (animatable.isPacified()) {
            if (animatable.isSleeping()) {
                return BERRY_PACIFIED_SLEEP_TEXTURE;
            }
            return BERRY_PACIFIED_TEXTURE;
        }
        if (animatable.isSleeping()) {
            return BERRY_SLEEP_TEXTURE;
        }
        return BERRY_TEXTURE;
    }

    public ResourceLocation getAnimationResource(PsychoBearEntity animatable) {
        if (animatable.isBaby()) {
            return BABY_ANIMATION;
        }
        return ANIMATION;
    }

    public void setCustomAnimations(PsychoBearEntity pEntity, long instanceId, AnimationState<PsychoBearEntity> animationState) {
        if (!pEntity.canAnimateLook()) {
            return;
        }
        GeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

