/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.client.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.client.init.ModLayerLocations;
import team.recrafted.blastfromthepast.init.ModItems;

public class FrostbiteAntlersLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    public static ResourceLocation ANTLERS_TEXTURE = BlastFromThePast.location("textures/models/armor/frost_bite_layer_1.png");
    public final AntlersModel<?> ANTLERS_MODEL = new AntlersModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModLayerLocations.ANTLERS));

    public FrostbiteAntlersLayer(LivingEntityRenderer<T, M> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.getItemBySlot(EquipmentSlot.HEAD).is(ModItems.FROST_BITE_HELMET) && !entity.isInvisible()) {
            VertexConsumer buffer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)ANTLERS_TEXTURE));
            int packedOverlay = LivingEntityRenderer.getOverlayCoords(entity, (float)0.0f);
            poseStack.pushPose();
            ((HumanoidModel)this.getParentModel()).head.translateAndRotate(poseStack);
            poseStack.scale(0.95f, 0.95f, 0.95f);
            this.ANTLERS_MODEL.renderToBuffer(poseStack, buffer, packedLight, packedOverlay);
            poseStack.popPose();
        }
    }

    public static class AntlersModel<T extends LivingEntity>
    extends EntityModel<T> {
        private static final String ANTLERS = "antlers";
        private final ModelPart antlers;

        public AntlersModel(ModelPart part) {
            super(RenderType::entitySolid);
            this.antlers = part.getChild(ANTLERS);
        }

        public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        }

        public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
            this.antlers.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        }

        public static LayerDefinition createHeadLayer() {
            MeshDefinition meshDefinition = new MeshDefinition();
            PartDefinition partDefinition = meshDefinition.getRoot();
            CubeListBuilder cubesBuilder = CubeListBuilder.create().texOffs(24, 0).addBox(4.5f, -12.0f, 0.0f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(24, 0).mirror().addBox(-12.5f, -12.0f, 0.0f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false);
            partDefinition.addOrReplaceChild(ANTLERS, cubesBuilder, PartPose.ZERO);
            return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
        }
    }
}

