/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.block.signs;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class SnowyStoneBlock
extends Block {
    public static final MapCodec<SnowyStoneBlock> CODEC = SnowyStoneBlock.simpleCodec(SnowyStoneBlock::new);
    public static final BooleanProperty SNOWY = BlockStateProperties.SNOWY;

    protected MapCodec<? extends SnowyStoneBlock> codec() {
        return CODEC;
    }

    public SnowyStoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SNOWY, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.UP ? (BlockState)state.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(SnowyStoneBlock.isSnowySetting(facingState))) : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos().above());
        return (BlockState)this.defaultBlockState().setValue((Property)SNOWY, (Comparable)Boolean.valueOf(SnowyStoneBlock.isSnowySetting(blockstate)));
    }

    private static boolean isSnowySetting(BlockState state) {
        return state.is(BlockTags.SNOW);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SNOWY});
    }
}

