/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.TriState;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModTreeGrowers;

public class PineconeBlock
extends SaplingBlock {
    public static final MapCodec<PineconeBlock> CODEC = RecordCodecBuilder.mapCodec(p_308831_ -> p_308831_.group((App)TreeGrower.CODEC.fieldOf("tree").forGetter(p_304527_ -> p_304527_.treeGrower), (App)PineconeBlock.propertiesCodec()).apply((Applicative)p_308831_, PineconeBlock::new));
    public static final BooleanProperty HANGING;
    protected static final VoxelShape SHAPE;
    protected static final VoxelShape SHAPE_HANGING;

    public MapCodec<PineconeBlock> codec() {
        return CODEC;
    }

    public PineconeBlock(TreeGrower treeGrower, BlockBehaviour.Properties properties) {
        super(treeGrower, properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STAGE}).add(new Property[]{HANGING});
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return super.mayPlaceOn(state, level, pos) || state.is(Blocks.CLAY);
    }

    public void advanceTree(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        if ((Integer)state.getValue((Property)STAGE) == 0) {
            level.setBlock(pos, (BlockState)state.cycle((Property)STAGE), 4);
        } else if (random.nextInt(100) < 20 || level.getBlockState(pos.below()).is(Blocks.PODZOL)) {
            ModTreeGrowers.RUSTY_CEDAR.growTree(level, level.getChunkSource().getGenerator(), pos, state, random);
        } else {
            this.treeGrower.growTree(level, level.getChunkSource().getGenerator(), pos, state, random);
        }
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (PineconeBlock.isHanging(state)) {
            return SHAPE_HANGING;
        }
        return SHAPE;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (PineconeBlock.isHanging(state)) {
            TriState soilDecision = level.getBlockState(pos.above()).canSustainPlant((BlockGetter)level, pos.above(), Direction.DOWN, state);
            return !soilDecision.isDefault() ? soilDecision.isTrue() : level.getBlockState(pos.above()).is(ModBlocks.CEDAR.LEAVES);
        }
        return super.canSurvive(state, level, pos);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!PineconeBlock.isHanging(state)) {
            super.randomTick(state, level, pos, random);
        }
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return !PineconeBlock.isHanging(state);
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return !PineconeBlock.isHanging(state) && super.isBonemealSuccess(level, random, pos, state);
    }

    private static boolean isHanging(BlockState state) {
        return (Boolean)state.getValue((Property)HANGING);
    }

    static {
        SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);
        SHAPE_HANGING = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0);
        HANGING = BlockStateProperties.HANGING;
    }
}

