/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class CedarLeavesBlock
extends LeavesBlock {
    public static final MapCodec<CedarLeavesBlock> CODEC = CedarLeavesBlock.simpleCodec(CedarLeavesBlock::new);
    public static final BooleanProperty SNOWY = BlockStateProperties.SNOWY;
    public static final BooleanProperty RUSTY = BooleanProperty.create((String)"rusty");

    public MapCodec<? extends CedarLeavesBlock> codec() {
        return CODEC;
    }

    public CedarLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return (BlockState)super.updateShape(state, facing, facingState, level, currentPos, facingPos).setValue((Property)SNOWY, (Comparable)Boolean.valueOf(CedarLeavesBlock.isSnowySetting(facingState, level, currentPos)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos().above());
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)RUSTY, (Comparable)Boolean.valueOf(false))).setValue((Property)SNOWY, (Comparable)Boolean.valueOf(CedarLeavesBlock.isSnowySetting(blockstate, (LevelAccessor)context.getLevel(), context.getClickedPos())));
    }

    private static boolean isSnowySetting(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockState blockState2 = level.getBlockState(pos.above());
        return blockState2.is(Blocks.SNOW);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SNOWY});
        builder.add(new Property[]{RUSTY});
    }
}

