/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import team.recrafted.blastfromthepast.init.ModBlockEntities;

public class BearTrapBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    public LivingEntity entity;
    public ItemEntity bait;
    public int timer = 0;
    public boolean hidden = false;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BearTrapBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.BEAR_TRAP.get(), pos, blockState);
    }

    public void interact(Level level, BlockPos pos, Player player) {
        if (player.getMainHandItem().is(Items.SNOW)) {
            if (!this.hidden) {
                player.getMainHandItem().consume(1, (LivingEntity)player);
            }
            this.hidden = true;
            return;
        }
        if (this.bait != null) {
            player.addItem(this.bait.getItem());
            this.bait.discard();
            this.bait = null;
        }
        if (player.getMainHandItem().isEmpty()) {
            return;
        }
        this.bait = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, new ItemStack((ItemLike)player.getMainHandItem().getItem(), 1));
        this.bait.makeFakeItem();
        this.bait.setInvisible(true);
        player.getMainHandItem().consume(1, (LivingEntity)player);
    }

    public void tick(Level level, BlockPos pos) {
        if (this.entity != null) {
            if (this.timer > 400 || !this.entity.isAlive() || this.entity.level() != level) {
                this.entity = null;
                this.timer = 0;
                level.destroyBlock(pos, false);
                return;
            }
            ++this.timer;
            if (!level.isClientSide) {
                this.entity.teleportTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            }
            this.entity.setDeltaMovement(0.0, 0.0, 0.0);
        }
    }

    public boolean isTrapping() {
        if (this.entity == null || !this.entity.isAlive()) {
            this.entity = null;
            this.timer = 0;
            return false;
        }
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

