/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.block;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import team.recrafted.blastfromthepast.block.CedarLeavesBlock;
import team.recrafted.blastfromthepast.block.CustomLogBlock;
import team.recrafted.blastfromthepast.block.signs.BFTPCeilingHangingSignBlock;
import team.recrafted.blastfromthepast.block.signs.BFTPStandingSignBlock;
import team.recrafted.blastfromthepast.block.signs.BFTPWallHangingSignBlock;
import team.recrafted.blastfromthepast.block.signs.BFTPWallSignBlock;
import team.recrafted.blastfromthepast.init.ModItems;

public class BFTPWoodGroup {
    public final DeferredBlock<Block> BLOCK;
    public final DeferredBlock<SlabBlock> SLAB;
    public final DeferredBlock<StairBlock> STAIRS;
    public final DeferredBlock<FenceBlock> FENCE;
    public final DeferredBlock<FenceGateBlock> FENCE_GATE;
    public final DeferredBlock<RotatedPillarBlock> LOG;
    public final DeferredBlock<RotatedPillarBlock> WOOD;
    public final DeferredBlock<RotatedPillarBlock> STRIPPED_WOOD;
    public final DeferredBlock<RotatedPillarBlock> STRIPPED_LOG;
    public final DeferredBlock<DoorBlock> DOOR;
    public final DeferredBlock<ButtonBlock> BUTTON;
    public final DeferredBlock<PressurePlateBlock> PRESSURE_PLATE;
    public final DeferredBlock<TrapDoorBlock> TRAPDOOR;
    public final DeferredBlock<StandingSignBlock> SIGN;
    public final DeferredItem<Item> SIGN_ITEM;
    public final DeferredBlock<WallSignBlock> WALL_SIGN;
    public final DeferredBlock<CeilingHangingSignBlock> HANGING_SIGN;
    public final DeferredBlock<WallHangingSignBlock> HANGING_SIGN_WALL;
    public final DeferredItem<Item> HANGING_SIGN_ITEM;
    public final DeferredBlock<Block> LEAVES;
    public final WoodType woodType;
    public final BlockSetType woodSetType;

    public BFTPWoodGroup(String name, MapColor color, Item.Properties empty, DeferredRegister.Blocks blockRegister) {
        this.woodSetType = BlockSetType.register((BlockSetType)new BlockSetType(name, true, true, true, BlockSetType.PressurePlateSensitivity.EVERYTHING, SoundType.WOOD, SoundEvents.WOODEN_DOOR_CLOSE, SoundEvents.WOODEN_DOOR_OPEN, SoundEvents.WOODEN_TRAPDOOR_CLOSE, SoundEvents.WOODEN_TRAPDOOR_CLOSE, SoundEvents.WOODEN_PRESSURE_PLATE_CLICK_OFF, SoundEvents.WOODEN_PRESSURE_PLATE_CLICK_ON, SoundEvents.WOODEN_BUTTON_CLICK_OFF, SoundEvents.WOODEN_BUTTON_CLICK_ON));
        this.woodType = WoodType.register((WoodType)new WoodType("blastfromthepast:" + name, this.woodSetType));
        this.BLOCK = blockRegister.register(name, () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).mapColor(color)));
        this.SLAB = blockRegister.register(name + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SLAB).mapColor(color)));
        this.STAIRS = blockRegister.register(name + "_stairs", () -> new StairBlock(((Block)this.BLOCK.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_STAIRS).mapColor(color)));
        this.FENCE = blockRegister.register(name + "_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE).mapColor(color)));
        this.FENCE_GATE = blockRegister.register(name + "_fence_gate", () -> new FenceGateBlock(this.woodType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE).mapColor(color)));
        this.STRIPPED_LOG = blockRegister.register("stripped_" + name + "_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG).mapColor(color)));
        this.LOG = blockRegister.register(name + "_log", () -> new CustomLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG).mapColor(color), (Supplier<? extends RotatedPillarBlock>)this.STRIPPED_LOG));
        this.STRIPPED_WOOD = blockRegister.register("stripped_" + name + "_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD).mapColor(color)));
        this.WOOD = blockRegister.register(name + "_wood", () -> new CustomLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD).mapColor(color), (Supplier<? extends RotatedPillarBlock>)this.STRIPPED_WOOD));
        this.DOOR = blockRegister.register(name + "_door", () -> new DoorBlock(this.woodSetType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR).mapColor(color)));
        this.BUTTON = blockRegister.register(name + "_button", () -> new ButtonBlock(this.woodSetType, 30, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_BUTTON).mapColor(color)));
        this.PRESSURE_PLATE = blockRegister.register(name + "_pressure_plate", () -> new PressurePlateBlock(this.woodSetType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE).mapColor(color)));
        this.SIGN = blockRegister.register(name + "_sign", () -> new BFTPStandingSignBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SIGN).mapColor(color), this.woodType));
        this.TRAPDOOR = blockRegister.register(name + "_trapdoor", () -> new TrapDoorBlock(this.woodSetType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR).mapColor(color)));
        this.WALL_SIGN = blockRegister.register(name + "_wall_sign", () -> new BFTPWallSignBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_SIGN).mapColor(color), this.woodType));
        this.HANGING_SIGN = blockRegister.register(name + "_hanging_sign", () -> new BFTPCeilingHangingSignBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_HANGING_SIGN).mapColor(color), this.woodType));
        this.HANGING_SIGN_WALL = blockRegister.register(name + "_hanging_wall_sign", () -> new BFTPWallHangingSignBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_HANGING_SIGN).mapColor(color), this.woodType));
        this.LEAVES = name.equals("cedar") ? blockRegister.register("cedar_leaves", () -> new CedarLeavesBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn((pState, pLevel, pPos, pValue) -> pValue == EntityType.OCELOT || pValue == EntityType.PARROT).isSuffocating((pState, pLevel, pPos) -> false).isViewBlocking((pState, pLevel, pPos) -> false).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor((pState, pLevel, pPos) -> false))) : blockRegister.register(name + "_leaves", BFTPWoodGroup::leaves);
        ModItems.register(name, () -> new BlockItem((Block)this.BLOCK.get(), empty));
        ModItems.register(name + "_slab", () -> new BlockItem((Block)this.SLAB.get(), empty));
        ModItems.register(name + "_stairs", () -> new BlockItem((Block)this.STAIRS.get(), empty));
        ModItems.register(name + "_fence", () -> new BlockItem((Block)this.FENCE.get(), empty));
        ModItems.register(name + "_fence_gate", () -> new BlockItem((Block)this.FENCE_GATE.get(), empty));
        ModItems.register("stripped_" + name + "_log", () -> new BlockItem((Block)this.STRIPPED_LOG.get(), empty));
        ModItems.register(name + "_log", () -> new BlockItem((Block)this.LOG.get(), empty));
        ModItems.register(name + "_wood", () -> new BlockItem((Block)this.WOOD.get(), empty));
        ModItems.register("stripped_" + name + "_wood", () -> new BlockItem((Block)this.STRIPPED_WOOD.get(), empty));
        ModItems.register(name + "_button", () -> new BlockItem((Block)this.BUTTON.get(), empty));
        ModItems.register(name + "_pressure_plate", () -> new BlockItem((Block)this.PRESSURE_PLATE.get(), empty));
        ModItems.register(name + "_trapdoor", () -> new BlockItem((Block)this.TRAPDOOR.get(), empty));
        this.SIGN_ITEM = ModItems.register(name + "_sign", () -> new SignItem(empty, (Block)this.SIGN.get(), (Block)this.WALL_SIGN.get()));
        this.HANGING_SIGN_ITEM = ModItems.register(name + "_hanging_sign", () -> new HangingSignItem((Block)this.HANGING_SIGN.get(), (Block)this.HANGING_SIGN_WALL.get(), empty));
        ModItems.register(name + "_door", () -> new DoubleHighBlockItem((Block)this.DOOR.get(), empty));
        ModItems.register(name + "_leaves", () -> new BlockItem((Block)this.LEAVES.get(), empty));
    }

    public static Block leaves() {
        return new LeavesBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn((pState, pLevel, pPos, pValue) -> pValue == EntityType.OCELOT || pValue == EntityType.PARROT).isSuffocating((pState, pLevel, pPos) -> false).isViewBlocking((pState, pLevel, pPos) -> false).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor((pState, pLevel, pPos) -> false));
    }
}

