/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.block;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import team.recrafted.blastfromthepast.block.signs.SnowyStoneBlock;
import team.recrafted.blastfromthepast.init.ModBlocks;

public class BFTPStoneGroup {
    public final DeferredBlock<Block> BLOCK;
    public final DeferredBlock<StairBlock> STAIRS;
    public final DeferredBlock<SlabBlock> SLAB;
    public final DeferredBlock<WallBlock> WALL;
    public final DeferredBlock<Block> BRICKS;
    public final DeferredBlock<StairBlock> BRICKS_STAIRS;
    public final DeferredBlock<SlabBlock> BRICKS_SLAB;
    public final DeferredBlock<WallBlock> BRICKS_WALL;
    public final DeferredBlock<Block> COBBLESTONE;
    public final DeferredBlock<StairBlock> COBBLESTONE_STAIRS;
    public final DeferredBlock<SlabBlock> COBBLESTONE_SLAB;
    public final DeferredBlock<WallBlock> COBBLESTONE_WALL;
    public final DeferredBlock<Block> CHISELED_BRICKS;
    public final DeferredBlock<Block> POLISHED;
    public final DeferredBlock<StairBlock> POLISHED_STAIRS;
    public final DeferredBlock<SlabBlock> POLISHED_SLAB;
    public final DeferredBlock<WallBlock> POLISHED_WALL;
    public final DeferredBlock<DropExperienceBlock> COAL_ORE;
    public final DeferredBlock<DropExperienceBlock> COPPER_ORE;
    public final DeferredBlock<DropExperienceBlock> DIAMOND_ORE;
    public final DeferredBlock<DropExperienceBlock> EMERALD_ORE;
    public final DeferredBlock<DropExperienceBlock> GOLD_ORE;
    public final DeferredBlock<DropExperienceBlock> IRON_ORE;
    public final DeferredBlock<DropExperienceBlock> LAPIS_ORE;
    public final DeferredBlock<RedStoneOreBlock> REDSTONE_ORE;
    public final List<DeferredBlock<?>> blocks;

    public BFTPStoneGroup(String name, MapColor mapColor, Item.Properties empty) {
        this.BLOCK = ModBlocks.createRegistry(name, () -> new SnowyStoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(mapColor)), empty);
        this.STAIRS = ModBlocks.createRegistry(name + "_stairs", () -> new StairBlock(((Block)this.BLOCK.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.BLOCK.get())).mapColor(mapColor)), empty);
        this.SLAB = ModBlocks.createRegistry(name + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.BLOCK.get())).mapColor(mapColor)), empty);
        this.WALL = ModBlocks.createRegistry(name + "_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.BLOCK.get())).mapColor(mapColor)), empty);
        this.BRICKS = ModBlocks.createRegistry(name + "_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(mapColor)), empty);
        this.BRICKS_STAIRS = ModBlocks.createRegistry(name + "_bricks_stairs", () -> new StairBlock(((Block)this.BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.BRICKS.get())).mapColor(mapColor)), empty);
        this.BRICKS_SLAB = ModBlocks.createRegistry(name + "_bricks_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.BRICKS.get())).mapColor(mapColor)), empty);
        this.BRICKS_WALL = ModBlocks.createRegistry(name + "_bricks_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.BRICKS.get())).mapColor(mapColor)), empty);
        this.COBBLESTONE = ModBlocks.createRegistry("cobbled_" + name, () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(mapColor)), empty);
        this.COBBLESTONE_STAIRS = ModBlocks.createRegistry("cobbled_" + name + "_stairs", () -> new StairBlock(((Block)this.COBBLESTONE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.COBBLESTONE.get())).mapColor(mapColor)), empty);
        this.COBBLESTONE_SLAB = ModBlocks.createRegistry("cobbled_" + name + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.COBBLESTONE.get())).mapColor(mapColor)), empty);
        this.COBBLESTONE_WALL = ModBlocks.createRegistry("cobbled_" + name + "_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.COBBLESTONE.get())).mapColor(mapColor)), empty);
        this.CHISELED_BRICKS = ModBlocks.createRegistry("chiseled_" + name + "_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(mapColor)), empty);
        this.POLISHED = ModBlocks.createRegistry("polished_" + name, () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(mapColor)), empty);
        this.POLISHED_STAIRS = ModBlocks.createRegistry("polished_" + name + "_stairs", () -> new StairBlock(((Block)this.POLISHED.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.POLISHED.get())).mapColor(mapColor)), empty);
        this.POLISHED_SLAB = ModBlocks.createRegistry("polished_" + name + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.POLISHED.get())).mapColor(mapColor)), empty);
        this.POLISHED_WALL = ModBlocks.createRegistry("polished_" + name + "_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.POLISHED.get())).mapColor(mapColor)), empty);
        this.COAL_ORE = ModBlocks.createRegistry(name + "_coal_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)0, (int)2), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COAL_ORE).mapColor(mapColor)), empty);
        this.COPPER_ORE = ModBlocks.createRegistry(name + "_copper_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_ORE).mapColor(mapColor)), empty);
        this.DIAMOND_ORE = ModBlocks.createRegistry(name + "_diamond_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIAMOND_ORE).mapColor(mapColor)), empty);
        this.EMERALD_ORE = ModBlocks.createRegistry(name + "_emerald_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.EMERALD_ORE).mapColor(mapColor)), empty);
        this.GOLD_ORE = ModBlocks.createRegistry(name + "_gold_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GOLD_ORE).mapColor(mapColor)), empty);
        this.IRON_ORE = ModBlocks.createRegistry(name + "_iron_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_ORE).mapColor(mapColor)), empty);
        this.LAPIS_ORE = ModBlocks.createRegistry(name + "_lapis_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)2, (int)5), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LAPIS_ORE).mapColor(mapColor)), empty);
        this.REDSTONE_ORE = ModBlocks.createRegistry(name + "_redstone_ore", () -> new RedStoneOreBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.REDSTONE_ORE).mapColor(mapColor)), empty);
        this.blocks = new ArrayList<DeferredBlock>(Arrays.asList(this.BLOCK, this.STAIRS, this.SLAB, this.WALL, this.BRICKS, this.BRICKS_STAIRS, this.BRICKS_SLAB, this.BRICKS_WALL, this.COBBLESTONE, this.COBBLESTONE_STAIRS, this.COBBLESTONE_SLAB, this.COBBLESTONE_WALL, this.POLISHED, this.POLISHED_STAIRS, this.POLISHED_SLAB, this.POLISHED_WALL, this.CHISELED_BRICKS, this.COAL_ORE, this.COPPER_ORE, this.DIAMOND_ORE, this.EMERALD_ORE, this.GOLD_ORE, this.IRON_ORE, this.LAPIS_ORE, this.REDSTONE_ORE));
    }

    public List<DeferredBlock<StairBlock>> getStairs() {
        return new ArrayList<DeferredBlock<StairBlock>>(Arrays.asList(this.STAIRS, this.BRICKS_STAIRS, this.POLISHED_STAIRS, this.COBBLESTONE_STAIRS));
    }

    public List<DeferredBlock<SlabBlock>> getSlab() {
        return new ArrayList<DeferredBlock<SlabBlock>>(Arrays.asList(this.SLAB, this.BRICKS_SLAB, this.POLISHED_SLAB, this.COBBLESTONE_SLAB));
    }

    public List<DeferredBlock<WallBlock>> getWall() {
        return new ArrayList<DeferredBlock<WallBlock>>(Arrays.asList(this.WALL, this.BRICKS_WALL, this.POLISHED_WALL, this.COBBLESTONE_WALL));
    }
}

