/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.block;

import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import team.recrafted.blastfromthepast.block.signs.SnowyStoneBlock;
import team.recrafted.blastfromthepast.init.ModBlocks;

public class BFTPBlockGroup {
    public final DeferredBlock<Block> BLOCK;
    public final DeferredBlock<StairBlock> STAIRS;
    public final DeferredBlock<SlabBlock> SLAB;
    public final DeferredBlock<WallBlock> WALL;

    public BFTPBlockGroup(String name, MapColor mapColor, BlockBehaviour.Properties behavior, Item.Properties empty) {
        this.BLOCK = ModBlocks.createRegistry(name, () -> new SnowyStoneBlock(behavior.mapColor(mapColor)), empty);
        this.STAIRS = ModBlocks.createRegistry(name + "_stairs", () -> new StairBlock(((Block)this.BLOCK.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.BLOCK.get())).mapColor(mapColor)), empty);
        this.SLAB = ModBlocks.createRegistry(name + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.BLOCK.get())).mapColor(mapColor)), empty);
        this.WALL = ModBlocks.createRegistry(name + "_wall", () -> new WallBlock(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)this.BLOCK.get())).mapColor(mapColor).forceSolidOn()), empty);
    }

    public DeferredBlock<StairBlock> getStairs() {
        return this.STAIRS;
    }

    public DeferredBlock<SlabBlock> getSlab() {
        return this.SLAB;
    }

    public DeferredBlock<WallBlock> getWall() {
        return this.WALL;
    }
}

