/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.IdMap;
import net.minecraft.resources.ResourceLocation;

public final class BasicRegistry<T>
implements Codec<T>,
IdMap<T> {
    private final Lifecycle lifecycle;
    private final BiMap<String, T> map = HashBiMap.create();
    private final ObjectList<T> byId = new ObjectArrayList();
    private final Object2IntMap<T> toId = new Object2IntOpenHashMap();
    private int nextId;

    public BasicRegistry(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
        this.toId.defaultReturnValue(-1);
    }

    public BasicRegistry() {
        this(Lifecycle.stable());
    }

    public void register(String name, T value) {
        int id = this.nextId++;
        this.map.put((Object)name, value);
        this.byId.size(id + 1);
        this.byId.set(id, value);
        this.toId.put(value, id);
    }

    public void register(ResourceLocation name, T value) {
        this.register(name.toString(), value);
    }

    @Nonnull
    public Lifecycle registryLifecycle() {
        return this.lifecycle;
    }

    @Nullable
    public T get(String name) {
        return (T)this.map.get((Object)name);
    }

    @Nullable
    public String getKey(T value) {
        return (String)this.map.inverse().get(value);
    }

    @Nonnull
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Nonnull
    public Set<T> values() {
        return this.map.values();
    }

    @Nonnull
    public Set<Map.Entry<String, T>> entrySet() {
        return this.map.entrySet();
    }

    public boolean containsKey(String name) {
        return this.map.containsKey((Object)name);
    }

    public int getId(T value) {
        return this.toId.getInt(value);
    }

    @Nullable
    public T byId(int id) {
        return (T)(id >= 0 && id < this.byId.size() ? this.byId.get(id) : null);
    }

    public int size() {
        return this.map.size();
    }

    public Iterator<T> iterator() {
        return this.map.values().iterator();
    }

    public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U input) {
        return Codec.STRING.decode(ops, input).flatMap(encodedRegistryPair -> {
            String name = (String)encodedRegistryPair.getFirst();
            T value = this.get(name);
            return value == null ? DataResult.error(() -> "Unknown registry key: " + name) : DataResult.success((Object)Pair.of(value, (Object)encodedRegistryPair.getSecond()), (Lifecycle)this.lifecycle);
        });
    }

    public <U> DataResult<U> encode(T input, DynamicOps<U> ops, U prefix) {
        String name = this.getKey(input);
        if (name == null) {
            return DataResult.error(() -> "Unknown registry element: " + String.valueOf(prefix));
        }
        return ops.mergeToPrimitive(prefix, ops.createString(name)).setLifecycle(this.lifecycle);
    }
}

