/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator.effects;

import com.teamabnormals.blueprint.core.endimator.Endimation;
import com.teamabnormals.blueprint.core.endimator.effects.ConfiguredEndimationEffect;
import com.teamabnormals.blueprint.core.endimator.effects.EndimationEffectSource;

public final class EndimationEffectHandler {
    private final EndimationEffectSource source;
    private int recentIndex;
    private float prevTime;

    public EndimationEffectHandler(EndimationEffectSource source) {
        this.source = source;
    }

    public void update(Endimation endimation, float time) {
        int recentIndex;
        if (this.prevTime > time) {
            this.reset();
        }
        this.prevTime = time;
        ConfiguredEndimationEffect<?, ?>[] effects = endimation.getEffects();
        int length = effects.length;
        if (length > 0 && recentIndex < length) {
            ConfiguredEndimationEffect<?, ?> effect;
            EndimationEffectSource source = this.source;
            for (recentIndex = this.recentIndex; recentIndex < length && (effect = effects[recentIndex]).getTime() <= time; ++recentIndex) {
                effect.process(source, time);
            }
            this.recentIndex = recentIndex;
        }
    }

    public void reset() {
        this.recentIndex = 0;
    }
}

