/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.storage.tracking;

import com.mojang.serialization.MapCodec;
import com.teamabnormals.blueprint.common.world.storage.tracking.SyncType;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class TrackedData<T> {
    @Nullable
    private final MapCodec<T> codec;
    private final StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec;
    private final Supplier<T> defaultValue;
    private final SyncType syncType;
    private final boolean persistent;

    private TrackedData(@Nullable MapCodec<T> codec, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec, Supplier<T> defaultValue, SyncType syncType, boolean persistent) {
        this.codec = codec;
        this.streamCodec = streamCodec;
        this.defaultValue = defaultValue;
        this.syncType = syncType;
        this.persistent = persistent;
    }

    @Nullable
    public MapCodec<T> getCodec() {
        return this.codec;
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, T> getStreamCodec() {
        return this.streamCodec;
    }

    public SyncType getSyncType() {
        return this.syncType;
    }

    public T getDefaultValue() {
        return this.defaultValue.get();
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public static class Builder<T> {
        @Nullable
        private MapCodec<T> codec;
        private final StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec;
        private final Supplier<T> defaultValue;
        private SyncType syncType;
        private boolean persistent;

        private Builder(StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec, Supplier<T> defaultValue) {
            this.streamCodec = streamCodec;
            this.defaultValue = defaultValue;
            this.syncType = SyncType.TO_CLIENTS;
        }

        public static <T> Builder<T> create(StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec, Supplier<T> defaultValue) {
            return new Builder<T>(streamCodec, defaultValue);
        }

        public Builder<T> setSyncType(SyncType syncType) {
            this.syncType = syncType;
            return this;
        }

        public Builder<T> enableSaving(MapCodec<T> codec) {
            this.codec = codec;
            return this;
        }

        public Builder<T> enablePersistence() {
            this.persistent = true;
            return this;
        }

        public TrackedData<T> build() {
            return new TrackedData<T>(this.codec, this.streamCodec, this.defaultValue, this.syncType, this.persistent);
        }
    }
}

