/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.advancement.modification.modifiers;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierSerializers;
import com.teamabnormals.blueprint.common.advancement.modification.BlueprintAdvancementBuilder;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.AdvancementModifier;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EffectsChangedTrigger;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.resources.RegistryOps;

public record EffectsChangedModifier(String criteria, boolean removes, MobEffectsPredicate mobEffectsPredicate) implements AdvancementModifier<EffectsChangedModifier>
{
    @Override
    public void modify(BlueprintAdvancementBuilder builder) {
        block9: {
            String criteriaKey;
            block8: {
                Optional<MobEffectsPredicate> source;
                Optional<MobEffectsPredicate> effects;
                Optional<MobEffectsPredicate> player;
                Criterion<?> criterion;
                block10: {
                    block6: {
                        block7: {
                            Optional<MobEffectsPredicate> optional;
                            criteriaKey = this.criteria;
                            criterion = builder.criteria.get(criteriaKey);
                            if (criterion == null) break block8;
                            CriterionTriggerInstance instance = criterion.triggerInstance();
                            if (!(instance instanceof EffectsChangedTrigger.TriggerInstance)) break block9;
                            EffectsChangedTrigger.TriggerInstance triggerInstance = (EffectsChangedTrigger.TriggerInstance)instance;
                            try {
                                player = optional = triggerInstance.player();
                            }
                            catch (Throwable throwable) {
                                throw new MatchException(throwable.toString(), throwable);
                            }
                            effects = optional = triggerInstance.effects();
                            source = optional = triggerInstance.source();
                            if (!effects.isEmpty()) break block6;
                            if (!this.removes) break block7;
                            return;
                        }
                        effects = Optional.of(this.mobEffectsPredicate);
                        break block10;
                    }
                    HashMap effectMap = new HashMap(((MobEffectsPredicate)effects.get()).effectMap());
                    if (this.removes) {
                        this.mobEffectsPredicate.effectMap().keySet().forEach(effectMap::remove);
                    } else {
                        effectMap.putAll(this.mobEffectsPredicate.effectMap());
                    }
                    effects = Optional.of(new MobEffectsPredicate(effectMap));
                }
                builder.addCriterion(criteriaKey, new Criterion(criterion.trigger(), (CriterionTriggerInstance)new EffectsChangedTrigger.TriggerInstance(player, effects, source)));
                break block9;
            }
            throw new IllegalArgumentException("Unknown criteria: " + criteriaKey);
        }
    }

    public Serializer getSerializer() {
        return AdvancementModifierSerializers.EFFECTS_CHANGED;
    }

    public static final class Serializer
    implements AdvancementModifier.Serializer<EffectsChangedModifier> {
        private static final Codec<EffectsChangedModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("criteria").forGetter(EffectsChangedModifier::criteria), (App)Codec.BOOL.fieldOf("removes").forGetter(EffectsChangedModifier::removes), (App)MobEffectsPredicate.CODEC.fieldOf("effects").forGetter(EffectsChangedModifier::mobEffectsPredicate)).apply((Applicative)instance, EffectsChangedModifier::new));

        @Override
        public JsonElement serialize(EffectsChangedModifier modifier, RegistryOps<JsonElement> ops) throws JsonParseException {
            DataResult result = CODEC.encodeStart(ops, (Object)modifier);
            Optional error = result.error();
            if (error.isPresent()) {
                throw new JsonParseException(((DataResult.Error)error.get()).message());
            }
            return (JsonElement)result.result().get();
        }

        @Override
        public EffectsChangedModifier deserialize(JsonElement element, RegistryOps<JsonElement> ops) throws JsonParseException {
            DataResult result = CODEC.decode(ops, (Object)element);
            Optional error = result.error();
            if (error.isPresent()) {
                throw new JsonParseException(((DataResult.Error)error.get()).message());
            }
            return (EffectsChangedModifier)((Pair)result.result().get()).getFirst();
        }
    }
}

