/*
 * Decompiled with CFR 0.152.
 */
package net.kreezcraft.mobsunscreen;

import net.kreezcraft.mobsunscreen.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class CommonClass {
    public static void onMobTick(LivingEntity entity) {
        if (!CommonClass.shouldProtectFromFire(entity)) {
            return;
        }
        if (CommonClass.isEntityInSunlight(entity) && entity.isOnFire() && !entity.isInLava()) {
            entity.clearFire();
        }
    }

    private static boolean shouldProtectFromFire(LivingEntity entity) {
        ResourceLocation entityKey = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        return Services.PLATFORM.protectAllMobs() || Services.PLATFORM.modsToProtect().contains(entityKey.getNamespace()) || Services.PLATFORM.mobsToProtect().contains(entityKey.toString());
    }

    private static boolean isEntityInSunlight(LivingEntity entity) {
        BlockPos eyePosition = BlockPos.containing((double)entity.getX(), (double)entity.getEyeY(), (double)entity.getZ());
        return entity.level().isDay() && entity.level().canSeeSky(eyePosition);
    }
}

