/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.wind;

import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.contents.ParagliderTags;
import tictim.paraglider.network.ParagliderNetwork;
import tictim.paraglider.wind.Wind;
import tictim.paraglider.wind.WindChunk;

public final class WindUtils {
    private WindUtils() {
    }

    public static void updateWind(@NotNull Level level) {
        Wind wind = Wind.of((LevelAccessor)level);
        if (wind == null) {
            return;
        }
        long gameTime = level.getGameTime();
        if (gameTime % 4L == 0L) {
            List players = level.players();
            for (Player player : players) {
                if (!player.getMainHandItem().is(ParagliderTags.PARAGLIDERS)) continue;
                wind.placeAround(player);
            }
        }
        wind.checkPlacedWind(level);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LongIterator it = wind.dirtyWindChunks().iterator();
            while (it.hasNext()) {
                long chunkPos = it.nextLong();
                WindChunk windChunk = wind.getChunk(chunkPos);
                if (windChunk == null) continue;
                LevelChunk chunk = level.getChunk(ChunkPos.getX((long)chunkPos), ChunkPos.getZ((long)chunkPos));
                ParagliderNetwork.get().syncWind(serverLevel.getServer(), chunk, windChunk);
            }
        }
        wind.dirtyWindChunks().clear();
    }
}

