/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.wind;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.wind.WindNode;

public final class WindChunk {
    public static final StreamCodec<FriendlyByteBuf, WindChunk> STREAM_CODEC = StreamCodec.of((buf, windChunk) -> windChunk.write((FriendlyByteBuf)buf), WindChunk::new);
    public final ChunkPos chunkPos;
    public final Byte2ObjectMap<WindNode> nodes = new Byte2ObjectOpenHashMap();
    private boolean removed;

    public WindChunk(@NotNull ChunkPos chunkPos) {
        this.chunkPos = Objects.requireNonNull(chunkPos);
    }

    public WindChunk(@NotNull FriendlyByteBuf buf) {
        this.chunkPos = new ChunkPos(buf.readLong());
        for (int i = buf.readVarInt(); i > 0; --i) {
            byte xz = buf.readByte();
            this.putNode(xz, new WindNode(buf));
        }
    }

    @Nullable
    public WindNode getNode(int x, int z) {
        return (WindNode)this.nodes.get(this.encode(x, z));
    }

    public void putNode(byte xz, @NotNull WindNode node) {
        this.nodes.put(xz, (Object)node);
    }

    public void removeAllNodesInXZ(int x, int z) {
        this.nodes.remove(this.encode(x, z));
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public boolean isRemoved() {
        return this.removed;
    }

    void setRemoved() {
        this.removed = true;
    }

    public int x(byte xz) {
        return (xz >> 4 & 0xF) + this.chunkPos.getMinBlockX();
    }

    public int z(byte xz) {
        return (xz & 0xF) + this.chunkPos.getMinBlockZ();
    }

    private byte encode(int x, int z) {
        return (byte)(x << 4 & 0xF0 | z & 0xF);
    }

    public boolean add(int x, int y, int z, int height, long gameTime) {
        byte xz = this.encode(x, z);
        WindNode node = (WindNode)this.nodes.get(xz);
        if (node != null) {
            return node.overwrite(y, height, gameTime);
        }
        this.putNode(xz, new WindNode(y, height, gameTime));
        return true;
    }

    public void write(@NotNull FriendlyByteBuf buf) {
        buf.writeLong(this.chunkPos.toLong());
        buf.writeVarInt(this.nodes.size());
        for (Byte2ObjectMap.Entry e : this.nodes.byte2ObjectEntrySet()) {
            buf.writeByte(e.getByteKey());
            ((WindNode)e.getValue()).write(buf);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindChunk windChunk = (WindChunk)o;
        return this.chunkPos.equals((Object)windChunk.chunkPos);
    }

    public int hashCode() {
        return this.chunkPos.hashCode();
    }
}

