/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.wind;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.wind.WindChunk;
import tictim.paraglider.wind.WindNode;
import tictim.paraglider.wind.WindSourceRegistry;

public final class Wind {
    private static final int XZ_RAD_HALF = 4;
    private static final int GROUND_Y_MIN = -2;
    private static final int GROUND_Y_MAX = 4;
    private static final int PARAGLIDING_Y_MAX = 1;
    private static final Map<LevelAccessor, Wind> windInstances = new Object2ObjectOpenHashMap();
    private final Long2ObjectMap<WindChunk> windChunks = new Long2ObjectOpenHashMap();
    private final LongSet dirtyWindChunks = new LongOpenHashSet();
    private final BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
    @Nullable
    private WindChunk windChunkCache;

    public static void registerLevel(@NotNull LevelAccessor level) {
        windInstances.computeIfAbsent(level, l -> new Wind());
    }

    public static void unregisterLevel(@NotNull LevelAccessor level) {
        windInstances.remove(level);
    }

    @Nullable
    public static Wind of(@NotNull LevelAccessor level) {
        return windInstances.get(level);
    }

    private Wind() {
    }

    @NotNull
    public @NotNull @Unmodifiable Collection<@NotNull WindChunk> windChunks() {
        return Collections.unmodifiableCollection(this.windChunks.values());
    }

    @NotNull
    public LongSet dirtyWindChunks() {
        return this.dirtyWindChunks;
    }

    @Nullable
    public WindChunk getChunk(@NotNull ChunkPos chunkPos) {
        return this.getChunk(chunkPos.x, chunkPos.z);
    }

    @Nullable
    public WindChunk getChunk(int chunkX, int chunkZ) {
        return this.getChunk(ChunkPos.asLong((int)chunkX, (int)chunkZ));
    }

    @Nullable
    public WindChunk getChunk(long chunkPos) {
        return (WindChunk)this.windChunks.get(chunkPos);
    }

    @NotNull
    public WindChunk getOrCreate(@NotNull ChunkPos chunkPos) {
        return this.getOrCreate(chunkPos.toLong());
    }

    @NotNull
    public WindChunk getOrCreate(int chunkX, int chunkZ) {
        return this.getOrCreate(ChunkPos.asLong((int)chunkX, (int)chunkZ));
    }

    @NotNull
    public WindChunk getOrCreate(long chunkPos) {
        return (WindChunk)this.windChunks.computeIfAbsent(chunkPos, cp -> new WindChunk(new ChunkPos(cp)));
    }

    @Nullable
    public WindChunk remove(int chunkX, int chunkZ) {
        return this.remove(ChunkPos.asLong((int)chunkX, (int)chunkZ));
    }

    @Nullable
    public WindChunk remove(@NotNull ChunkPos chunkPos) {
        return this.remove(chunkPos.toLong());
    }

    @Nullable
    public WindChunk remove(long chunkPos) {
        WindChunk removed = (WindChunk)this.windChunks.remove(chunkPos);
        if (removed != null) {
            removed.setRemoved();
        }
        return removed;
    }

    public void put(@NotNull WindChunk windChunk) {
        if (windChunk.isRemoved()) {
            throw new IllegalArgumentException("Cannot add back a removed wind chunk!");
        }
        this.windChunks.put(windChunk.chunkPos.toLong(), (Object)windChunk);
    }

    public void writeWind(int x, int y, int z, int height, long gameTime) {
        long chunkPos = ChunkPos.asLong((int)SectionPos.blockToSectionCoord((int)x), (int)SectionPos.blockToSectionCoord((int)z));
        if (this.windChunkCache == null || this.windChunkCache.isRemoved() || this.windChunkCache.chunkPos.toLong() != chunkPos) {
            this.windChunkCache = this.getOrCreate(chunkPos);
        }
        if (this.windChunkCache.add(x, y, z, height, gameTime)) {
            this.dirtyWindChunks().add(chunkPos);
        }
    }

    public void placeAround(@NotNull Player player) {
        int x = Mth.floor((double)player.getX());
        int y = Mth.floor((double)player.getY());
        int z = Mth.floor((double)player.getZ());
        this.place(player.level(), x - 4, y + (player.onGround() ? -2 : -WindSourceRegistry.get().maxWindHeight() - 1), z - 4, x + 4, y + (player.onGround() ? 4 : 1), z + 4);
    }

    private void place(@NotNull Level level, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            block1: for (int z = minZ; z <= maxZ; ++z) {
                if (!level.getChunkSource().hasChunk(SectionPos.blockToSectionCoord((int)x), SectionPos.blockToSectionCoord((int)z))) continue;
                boolean foundWindSource = false;
                int windSourceY = 0;
                int windSourceHeight = 0;
                int y = minY;
                while (true) {
                    block9: {
                        int blockStateWindSourceHeight;
                        block8: {
                            this.mpos.set(x, y, z);
                            BlockState state = level.getBlockState((BlockPos)this.mpos);
                            FluidState fluidState = level.getFluidState((BlockPos)this.mpos);
                            blockStateWindSourceHeight = WindSourceRegistry.get().getWindSourceHeight(state);
                            if (!foundWindSource) break block8;
                            int height = y - windSourceY;
                            if (height <= windSourceHeight && blockStateWindSourceHeight <= 0 && fluidState.isEmpty() && ParagliderUtils.windCanPassThrough(level, (BlockPos)this.mpos, state)) break block9;
                            if (height > 1) {
                                this.writeWind(x, windSourceY, z, height, level.getGameTime());
                            }
                            foundWindSource = false;
                        }
                        if (y > maxY) continue block1;
                        if (blockStateWindSourceHeight > 0) {
                            foundWindSource = true;
                            windSourceY = y;
                            windSourceHeight = blockStateWindSourceHeight;
                        }
                    }
                    ++y;
                }
            }
        }
    }

    public void checkPlacedWind(@NotNull Level level) {
        for (WindChunk windChunk : this.windChunks()) {
            ObjectIterator it = windChunk.nodes.byte2ObjectEntrySet().iterator();
            while (it.hasNext()) {
                WindNode node;
                Byte2ObjectMap.Entry e = (Byte2ObjectMap.Entry)it.next();
                byte xz = e.getByteKey();
                WindNode updated = this.validate(windChunk, xz, node = (WindNode)e.getValue(), level);
                if (updated == node) continue;
                if (updated == null) {
                    it.remove();
                    continue;
                }
                windChunk.nodes.put(xz, (Object)updated);
            }
        }
    }

    @Nullable
    private WindNode validate(@NotNull WindChunk windChunk, byte xz, @NotNull WindNode node, @NotNull Level level) {
        long gameTime = level.getGameTime();
        if (node.updatedTime != gameTime) {
            if (node.isExpired(gameTime) || WindSourceRegistry.get().getWindSourceHeight(level.getBlockState((BlockPos)this.mpos.set(windChunk.x(xz), node.y, windChunk.z(xz)))) <= 0) {
                this.dirtyWindChunks().add(windChunk.chunkPos.toLong());
                return node.next != null ? this.validate(windChunk, xz, node.next, level) : null;
            }
            node.updatedTime = gameTime;
        }
        if (node.next != null) {
            node.next = this.validate(windChunk, xz, node.next, level);
        }
        return node;
    }

    public static double getWindAbove(@NotNull Level level, @NotNull AABB boundingBox) {
        int maxWindY = Wind.getMaxWindY(level, Mth.floor((double)boundingBox.minX), Mth.floor((double)boundingBox.minY), Mth.floor((double)boundingBox.minZ), Mth.ceil((double)boundingBox.maxX) - 1, Mth.ceil((double)boundingBox.maxY) - 1, Mth.ceil((double)boundingBox.maxZ) - 1);
        return Math.max(0.0, (double)maxWindY - boundingBox.minY);
    }

    private static int getMaxWindY(@NotNull Level level, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        Wind wind = Wind.of((LevelAccessor)level);
        if (wind == null) {
            return 0;
        }
        int chunkXStart = minX >> 4;
        int chunkXEnd = maxX >> 4;
        int chunkZStart = minZ >> 4;
        int chunkZEnd = maxZ >> 4;
        int maxWindY = Integer.MIN_VALUE;
        for (int x = chunkXStart; x <= chunkXEnd; ++x) {
            for (int z = chunkZStart; z <= chunkZEnd; ++z) {
                WindChunk windChunk = wind.getChunk(x, z);
                if (windChunk == null) continue;
                maxWindY = Math.max(maxWindY, Wind.getMaxWindY(windChunk, minX, minY, minZ, maxX, maxY, maxZ));
            }
        }
        return maxWindY;
    }

    private static int getMaxWindY(WindChunk chunk, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int xs = Math.max(chunk.chunkPos.getMinBlockX(), minX);
        int xe = Math.min(chunk.chunkPos.getMaxBlockX(), maxX);
        int zs = Math.max(chunk.chunkPos.getMinBlockZ(), minZ);
        int ze = Math.min(chunk.chunkPos.getMaxBlockZ(), maxZ);
        int maxWindY = Integer.MIN_VALUE;
        for (int x = xs; x <= xe; ++x) {
            for (int z = zs; z <= ze; ++z) {
                WindNode node = chunk.getNode(x, z);
                while (node != null) {
                    if (node.y <= maxY && node.y + node.height > minY) {
                        maxWindY = Math.max(maxWindY, node.y + node.height);
                    }
                    node = node.next;
                }
            }
        }
        return maxWindY;
    }
}

