/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.api.plugin.ConflictResolver;
import tictim.paraglider.api.plugin.ParagliderPluginBase;
import tictim.paraglider.api.plugin.PluginAction;

public final class ParagliderPluginUtils {
    private ParagliderPluginUtils() {
    }

    @NotNull
    public static <T> List<T> removeAll(@NotNull Collection<T> collection, @NotNull Predicate<T> condition) {
        ArrayList<T> newList = new ArrayList<T>();
        Iterator<T> it = collection.iterator();
        while (it.hasNext()) {
            T t = it.next();
            if (!condition.test(t)) continue;
            it.remove();
            newList.add(t);
        }
        return newList;
    }

    public static <P extends ParagliderPluginBase, A> @Nullable List<@NotNull PluginAction<P, A>> resolve(@NotNull Function<P, ConflictResolver<P, ? super A>> resolverGetter, @NotNull @NotNull List<@NotNull PluginAction<P, A>> conflictingActions) {
        if (conflictingActions.isEmpty()) {
            return null;
        }
        if (conflictingActions.size() == 1) {
            return List.of(conflictingActions.get(0));
        }
        PluginAction[] arr = conflictingActions.toArray(new PluginAction[0]);
        ArrayList<PluginAction<P, A>> proceededActions = new ArrayList<PluginAction<P, A>>();
        block5: for (int i = 0; i < arr.length; ++i) {
            PluginAction action = arr[i];
            PluginAction[] arr2 = new PluginAction[arr.length - 1];
            if (i > 0) {
                System.arraycopy(arr, 0, arr2, 0, i);
            }
            if (i < arr.length - 1) {
                System.arraycopy(arr, i + 1, arr2, i, arr.length - i - 1);
            }
            ConflictResolver resolver = resolverGetter.apply(action.plugin().instance());
            Objects.requireNonNull(resolver, "Plugin instance " + String.valueOf(action.plugin()) + " provided null as ConflictResolver");
            ConflictResolver.Resolution resolution = resolver.resolveConflict(action.action(), arr2);
            Objects.requireNonNull(resolution, "ConflictResolver provided by plugin instance " + String.valueOf(action.plugin()) + " returned null");
            switch (resolution) {
                case PROCEED: {
                    proceededActions.add(action);
                    continue block5;
                }
                case ABORT: {
                    continue block5;
                }
                case ERROR: {
                    return null;
                }
            }
        }
        return proceededActions;
    }

    @NotNull
    public static <P extends ParagliderPluginBase, A> RuntimeException composePluginLoadingError(@NotNull @NotNull List<@NotNull PluginAction<P, A>> conflictingActions) {
        return new RuntimeException("Cannot continue loading paraglider plugins due to conflicting actions between plugins\n  " + conflictingActions.stream().map(pa -> String.valueOf(pa.action()) + " by " + String.valueOf(pa.plugin().instance()) + (String)(pa.plugin().modid() != null ? " (mod " + pa.plugin().modid() + ")" : "")).collect(Collectors.joining("\n  ")));
    }
}

