/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.stamina;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.api.plugin.PluginAction;
import tictim.paraglider.api.plugin.PluginInstance;
import tictim.paraglider.api.stamina.StaminaFactory;
import tictim.paraglider.api.stamina.StaminaPlugin;
import tictim.paraglider.api.stamina.StaminaPluginAction;
import tictim.paraglider.impl.stamina.BotWStaminaFactory;
import tictim.paraglider.plugin.ParagliderPluginLoader;
import tictim.paraglider.plugin.ParagliderPluginUtils;

public final class StaminaLoader {
    private StaminaLoader() {
    }

    public static @NotNull Pair<StaminaFactory, @Nullable String> loadStaminaFactory() {
        return StaminaLoader.loadStaminaFactory(ParagliderPluginLoader.get().getStaminaPlugins());
    }

    private static @NotNull Pair<StaminaFactory, @Nullable String> loadStaminaFactory(@NotNull @NotNull List<@NotNull PluginInstance<StaminaPlugin>> plugins) {
        ArrayList<PluginAction<StaminaPlugin, StaminaPluginAction.ProvideStaminaFactory>> factories = new ArrayList<PluginAction<StaminaPlugin, StaminaPluginAction.ProvideStaminaFactory>>();
        for (PluginInstance<StaminaPlugin> plugin : plugins) {
            StaminaFactory factory = plugin.instance().getStaminaFactory();
            if (factory == null) continue;
            factories.add(new PluginAction<StaminaPlugin, StaminaPluginAction.ProvideStaminaFactory>(plugin, new StaminaPluginAction.ProvideStaminaFactory(factory)));
        }
        return StaminaLoader.resolveAndGet(factories, false);
    }

    private static @NotNull Pair<StaminaFactory, @Nullable String> resolveAndGet(List<PluginAction<StaminaPlugin, StaminaPluginAction.ProvideStaminaFactory>> factories, boolean resolved) {
        return switch (factories.size()) {
            case 0 -> Pair.of((Object)new BotWStaminaFactory(), (Object)"paraglider");
            case 1 -> Pair.of((Object)factories.get(0).action().factory(), (Object)factories.get(0).plugin().modid());
            default -> {
                if (resolved) {
                    throw ParagliderPluginUtils.composePluginLoadingError(factories);
                }
                List<PluginAction<StaminaPlugin, StaminaPluginAction.ProvideStaminaFactory>> resolvedActions = ParagliderPluginUtils.resolve(StaminaPlugin::getStaminaPluginConflictResolver, factories);
                if (resolvedActions == null) {
                    throw ParagliderPluginUtils.composePluginLoadingError(factories);
                }
                yield StaminaLoader.resolveAndGet(resolvedActions, true);
            }
        };
    }

    public static @NotNull Pair<Boolean, @Nullable String> loadStaminaWheelRemoverId() {
        for (PluginInstance<StaminaPlugin> plugin : ParagliderPluginLoader.get().getStaminaPlugins()) {
            if (!plugin.instance().removeStaminaWheel()) continue;
            return Pair.of((Object)true, (Object)plugin.modid());
        }
        return Pair.of((Object)false, null);
    }
}

