/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.stamina;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.api.stamina.StaminaEfficiencyLogic;
import tictim.paraglider.api.stamina.StaminaEfficiencyLogicHandler;

public final class StaminaEfficiencyLogicHandlerImpl
implements StaminaEfficiencyLogicHandler {
    private final List<StaminaEfficiencyLogic> logics;

    public StaminaEfficiencyLogicHandlerImpl(@NotNull @Unmodifiable List<StaminaEfficiencyLogic> logics) {
        this.logics = logics;
    }

    @NotNull
    public @Unmodifiable List<StaminaEfficiencyLogic> logics() {
        return this.logics;
    }

    @Override
    public double getEfficiencySum(double baseStaminaDelta, @NotNull StaminaEfficiencyLogic.Context context) {
        if (baseStaminaDelta == 0.0 || Double.isNaN(baseStaminaDelta)) {
            return baseStaminaDelta;
        }
        Objects.requireNonNull(context, "context == null");
        double sum = 0.0;
        for (StaminaEfficiencyLogic logic : this.logics()) {
            double value;
            if (!logic.isApplicable(baseStaminaDelta, context) || Double.isNaN(value = logic.getEfficiency(baseStaminaDelta, context))) continue;
            sum += value;
        }
        return Double.isNaN(sum) ? 0.0 : sum;
    }
}

