/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.stamina;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.api.stamina.StaminaEfficiencyLogic;
import tictim.paraglider.api.stamina.StaminaPlugin;

public record AttributeStaminaEfficiencyLogic(@NotNull Supplier<Holder<Attribute>> attribute, @NotNull StaminaPlugin.AttributeEfficiencyCondition condition) implements StaminaEfficiencyLogic
{
    @Override
    public boolean isApplicable(double baseStaminaDelta, @NotNull StaminaEfficiencyLogic.Context context) {
        Player p = context.player();
        if (p == null) {
            return false;
        }
        AttributeInstance a = p.getAttribute(this.attribute.get());
        if (a == null) {
            return false;
        }
        return this.condition.isApplicable(baseStaminaDelta, context, p);
    }

    @Override
    public double getEfficiency(double baseStaminaDelta, @NotNull StaminaEfficiencyLogic.Context context) {
        return Objects.requireNonNull(context.player()).getAttributeValue(this.attribute.get()) - 1.0;
    }
}

