/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.movement;

import java.util.ArrayList;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.api.movement.PlayerState;

public record SimplePlayerState(@NotNull ResourceLocation id, @NotNull @NotNull @Unmodifiable Set<@NotNull ResourceLocation> flags, double staminaDelta, int recoveryDelay) implements PlayerState
{
    public SimplePlayerState(@NotNull PlayerState originalState, double staminaDelta, int recoveryDelay) {
        this(originalState.id(), originalState.flags(), staminaDelta, recoveryDelay);
    }

    @NotNull
    public static SimplePlayerState read(@NotNull FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.readResourceLocation();
        ArrayList<ResourceLocation> flags = new ArrayList<ResourceLocation>();
        int count = buffer.readVarInt();
        for (int i = 0; i < count; ++i) {
            flags.add(buffer.readResourceLocation());
        }
        double staminaDelta = buffer.readDouble();
        int recoveryDelay = buffer.readVarInt();
        return new SimplePlayerState(id, Set.of(flags.toArray(new ResourceLocation[0])), staminaDelta, recoveryDelay);
    }

    public static void write(@NotNull FriendlyByteBuf buffer, @NotNull PlayerState state) {
        buffer.writeResourceLocation(state.id());
        Set<ResourceLocation> flags = state.flags();
        buffer.writeVarInt(flags.size());
        for (ResourceLocation flag : flags) {
            buffer.writeResourceLocation(flag);
        }
        buffer.writeDouble(state.staminaDelta());
        buffer.writeVarInt(state.recoveryDelay());
    }
}

