/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.movement;

import java.util.ArrayDeque;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.api.movement.Movement;
import tictim.paraglider.api.movement.PlayerState;
import tictim.paraglider.api.movement.PlayerStateCondition;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.api.stamina.StaminaEfficiencyLogic;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.config.Cfg;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.ParagliderAdvancements;
import tictim.paraglider.contents.ParagliderTags;
import tictim.paraglider.impl.MovementState;
import tictim.paraglider.impl.SimpleVesselContainer;
import tictim.paraglider.impl.movement.PlayerMovement;
import tictim.paraglider.impl.movement.PlayerMovementValues;
import tictim.paraglider.network.ParagliderNetwork;

public class ServerPlayerMovement
extends PlayerMovement
implements PlayerStateCondition.Context {
    private boolean resync;
    private boolean heartContainerChanged = true;
    private boolean staminaVesselChanged = true;
    private boolean movementChanged;
    private double prevY;
    private double accumulatedFallDistance;
    private double staminaEfficiency;
    private double prevStaminaEfficiency;
    private final ArrayDeque<Effect> particleEffectQueue = new ArrayDeque(10);

    public ServerPlayerMovement(@NotNull ServerPlayer player) {
        super((Player)player);
        SimpleVesselContainer vessels = (SimpleVesselContainer)player.getData(Contents.get().vesselContainer());
        vessels.onChange((actionType, change, playEffect) -> {
            switch (actionType) {
                case HEART_CONTAINER: {
                    this.heartContainerChanged = true;
                    break;
                }
                case STAMINA_VESSEL: {
                    this.staminaVesselChanged = true;
                }
            }
            if (playEffect) {
                this.particleEffectQueue.add(new Effect(actionType, change));
            }
        });
    }

    @Override
    @NotNull
    public ServerPlayer player() {
        return (ServerPlayer)super.player();
    }

    @Override
    @NotNull
    protected Stamina createCustomStamina() {
        return ParagliderAPI.staminaFactory().createServerInstance(this.player());
    }

    @Override
    protected boolean isRemote() {
        return false;
    }

    @Override
    public @Range(from=0L, to=0x7FFFFFFFL) int recoveryDelay() {
        return this.movementState().recoveryDelay();
    }

    @Override
    public void setRecoveryDelay(int recoveryDelay) {
        this.movementState().setRecoveryDelay(recoveryDelay);
    }

    @Override
    public double staminaDelta() {
        return StaminaEfficiencyLogic.applyEfficiency(this.state().staminaDelta(), this.staminaEfficiency);
    }

    @Override
    @NotNull
    public Movement movement() {
        return this;
    }

    @Override
    @NotNull
    public PlayerState prevState() {
        return this.state();
    }

    @Override
    public double accumulatedFallDistance() {
        return this.accumulatedFallDistance;
    }

    @Override
    public boolean canDoPanicParagliding() {
        return this.movementState().canDoPanicParagliding();
    }

    @Override
    public void update() {
        double delta;
        SimpleVesselContainer vessels;
        boolean vesselsChanged;
        boolean resync = this.resync;
        this.resync = false;
        boolean bl = vesselsChanged = this.heartContainerChanged || this.staminaVesselChanged;
        if (this.heartContainerChanged) {
            vessels = (SimpleVesselContainer)this.player().getData(Contents.get().vesselContainer());
            delta = ParagliderUtils.refreshAttribute((Player)this.player(), (Holder<Attribute>)Attributes.MAX_HEALTH, Cfg.get().additionalMaxHealth(vessels.heartContainer()), PlayerMovementValues.HEART_CONTAINER_ATTRIBUTE_ID);
            if (delta > 0.0) {
                this.player().setHealth(this.player().getMaxHealth());
            } else {
                float maxHealth;
                float health = this.player().getHealth();
                if (health > (maxHealth = this.player().getMaxHealth())) {
                    this.player().setHealth(maxHealth);
                }
            }
            this.heartContainerChanged = false;
        }
        if (this.staminaVesselChanged) {
            vessels = (SimpleVesselContainer)this.player().getData(Contents.get().vesselContainer());
            delta = ParagliderUtils.refreshAttribute((Player)this.player(), Contents.get().maxStamina(), Cfg.get().maxStamina(vessels.staminaVessel()), PlayerMovementValues.STAMINA_VESSEL_ATTRIBUTE_ID);
            if (delta > 0.0) {
                this.stamina().setStamina(this.stamina().maxStamina());
            } else {
                double maxStamina;
                double stamina = this.stamina().stamina();
                if (stamina > (maxStamina = this.stamina().maxStamina())) {
                    this.stamina().setStamina(maxStamina);
                }
            }
            this.staminaVesselChanged = false;
        }
        this.accumulatedFallDistance = this.player().onGround() || this.player().getY() > this.prevY ? 0.0 : (this.accumulatedFallDistance += this.prevY - this.player().getY());
        if (!((Boolean)this.player().getData(Contents.get().movementInitialized())).booleanValue()) {
            this.player().setData(Contents.get().movementInitialized(), (Object)true);
            this.stamina().setStamina(this.stamina().maxStamina());
        }
        PlayerState prevState = this.state();
        this.setState(ParagliderMod.instance().getPlayerConnectionMap().evaluate(ParagliderMod.instance().getLocalPlayerStateMap(), this));
        this.staminaEfficiency = StaminaEfficiencyLogic.handler().getEfficiencySum(this.state().staminaDelta(), (Player)this.player(), this.state());
        if (this.prevStaminaEfficiency != this.staminaEfficiency) {
            this.movementChanged = true;
        }
        if (!prevState.equals(this.state())) {
            this.movementChanged = true;
            if (!prevState.paragliding() && this.state().paragliding()) {
                ParagliderUtils.playParagliderDeploySound((Player)this.player());
            }
        }
        this.updateStamina();
        if (!this.player().isCreative() && this.stamina().isDepleted()) {
            ParagliderUtils.addExhaustion((LivingEntity)this.player());
            ParagliderUtils.addFlyingBan((LivingEntity)this.player());
        } else {
            ParagliderUtils.removeExhaustion((LivingEntity)this.player());
            ParagliderUtils.removeFlyingBan((LivingEntity)this.player());
        }
        this.applyMovement();
        if (resync || this.movementChanged || this.stamina().isDirty()) {
            ParagliderNetwork.get().syncMovement(this.player(), this.state().id(), this.stamina().stamina(), this.stamina().extraStamina(), this.stamina().isDepleted(), this.recoveryDelay(), this.staminaEfficiency);
            this.movementChanged = false;
            this.stamina().setDirty(false);
        }
        if (resync || vesselsChanged) {
            SimpleVesselContainer vessels2 = (SimpleVesselContainer)this.player().getData(Contents.get().vesselContainer());
            ParagliderNetwork.get().syncVessels(this.player(), this.stamina().stamina(), this.stamina().extraStamina(), this.stamina().isDepleted(), vessels2.heartContainer(), vessels2.staminaVessel());
            if (vesselsChanged && Cfg.get().maxHeartContainers() <= vessels2.heartContainer() && Cfg.get().maxStaminaVessels() <= vessels2.staminaVessel()) {
                ParagliderUtils.giveAdvancement(this.player(), ParagliderAdvancements.ALL_VESSELS, "code_triggered");
            }
        }
        this.prevY = this.player().getY();
        this.prevStaminaEfficiency = this.staminaEfficiency;
        for (int i = 0; i < this.player().getInventory().getContainerSize(); ++i) {
            ItemStack stack = this.player().getInventory().getItem(i);
            if (!stack.is(ParagliderTags.PARAGLIDERS)) continue;
            ParagliderUtils.getCaps(stack).setParagliding(stack, i == this.player().getInventory().selected && this.state().paragliding());
        }
        while (!this.particleEffectQueue.isEmpty()) {
            Effect effect = this.particleEffectQueue.pop();
            switch (effect.actionType) {
                case HEART_CONTAINER: {
                    this.spawnParticle((ParticleOptions)ParticleTypes.HEART, 5 + 5 * effect.change);
                    break;
                }
                case STAMINA_VESSEL: {
                    this.spawnParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, 7 + 7 * effect.change);
                }
            }
        }
    }

    @Override
    protected void applyMovement() {
        super.applyMovement();
        boolean paragliding = this.state().paragliding();
        if (paragliding) {
            this.player().connection.aboveGroundTickCount = 0;
            ItemStack stack = this.player().getMainHandItem();
            if (stack.is(ParagliderTags.PARAGLIDERS)) {
                ParagliderUtils.getCaps(stack).damageParaglider((Player)this.player(), stack);
            }
        }
        if (!this.player().isCreative() && this.stamina().isDepleted()) {
            MovementState movementState = this.movementState();
            if (movementState.panicParaglidingDelay() > 0) {
                if (!this.player().onGround()) {
                    movementState.setPanicParaglidingDelay(movementState.panicParaglidingDelay() - 1);
                } else {
                    movementState.resetPanicParaglidingState();
                }
            } else if (movementState.panicParagliding()) {
                movementState.setPanicParaglidingDelay(30);
                movementState.setPanicParagliding(false);
            } else if (paragliding) {
                movementState.setPanicParaglidingDelay(15);
                movementState.setPanicParagliding(true);
            }
        }
    }

    @Override
    protected void updateStamina() {
        boolean remote = this.isRemote();
        Stamina stamina = this.stamina();
        if (!stamina.updateWithDefaultLogic(remote)) {
            return;
        }
        boolean wasDepleted = stamina.isDepleted();
        super.updateStamina();
        if (stamina.isDepleted()) {
            if (stamina.stamina() >= Math.min(stamina.maxStamina(), 3000.0)) {
                stamina.setDepleted(false, true);
                this.movementChanged = true;
            }
        } else if (stamina.stamina() <= 0.0 && stamina.extraStamina() <= 0.0) {
            stamina.setDepleted(true, true);
            this.movementState().resetPanicParaglidingState();
            this.movementChanged = true;
        }
        if (wasDepleted != stamina.isDepleted()) {
            this.movementChanged = true;
        }
    }

    public void markForSync() {
        this.resync = true;
    }

    protected void spawnParticle(@NotNull ParticleOptions particle, int count) {
        this.player().serverLevel().sendParticles(particle, this.player().getX(), this.player().getY(0.5), this.player().getZ(), count, 1.0, 2.0, 1.0, 0.0);
    }

    protected MovementState movementState() {
        return (MovementState)this.player().getData(Contents.get().movementState());
    }

    private record Effect(VesselContainer.ActionType actionType, int change) {
    }
}

