/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.movement;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.api.movement.PlayerState;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.api.stamina.StaminaEfficiencyLogic;
import tictim.paraglider.impl.movement.PlayerMovement;
import tictim.paraglider.impl.movement.PlayerStateMap;
import tictim.paraglider.network.SyncMovementHandle;

public class RemotePlayerMovement
extends PlayerMovement
implements SyncMovementHandle {
    private int recoveryDelay;
    private double staminaEfficiency;

    public RemotePlayerMovement(@NotNull Player player) {
        super(player);
    }

    @Override
    @NotNull
    protected Stamina createCustomStamina() {
        return ParagliderAPI.staminaFactory().createRemoteInstance(this.player());
    }

    @Override
    protected boolean isRemote() {
        return true;
    }

    @Override
    public void update() {
    }

    @Override
    public void syncMovement(@NotNull ResourceLocation stateId, int recoveryDelay, double efficiency) {
        PlayerStateMap stateMap = ParagliderMod.instance().getPlayerStateMap();
        PlayerState state = stateMap.getState(stateId);
        this.setState(state == null ? stateMap.getIdleState() : state);
        this.setRecoveryDelay(recoveryDelay);
        this.staminaEfficiency = efficiency;
    }

    @Override
    public @Range(from=0L, to=0x7FFFFFFFL) int recoveryDelay() {
        return this.recoveryDelay;
    }

    @Override
    public void setRecoveryDelay(int recoveryDelay) {
        this.recoveryDelay = Math.max(0, recoveryDelay);
    }

    @Override
    public double staminaDelta() {
        return StaminaEfficiencyLogic.applyEfficiency(this.state().staminaDelta(), this.staminaEfficiency());
    }

    public double staminaEfficiency() {
        return this.staminaEfficiency;
    }
}

