/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.movement;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.api.movement.ParagliderPlayerStates;
import tictim.paraglider.api.movement.PlayerState;
import tictim.paraglider.api.movement.PlayerStateCondition;
import tictim.paraglider.impl.movement.PlayerStateMap;

public final class PlayerStateConnectionMap {
    private final Map<ResourceLocation, ConnectionList> connections;
    private final Object2IntMap<ResourceLocation> stateEvalIndices = new Object2IntOpenHashMap();

    public PlayerStateConnectionMap(@NotNull @NotNull Map<@NotNull ResourceLocation, @NotNull ConnectionList> connections) {
        this.connections = connections;
    }

    @NotNull
    public @NotNull @Unmodifiable Map<@NotNull ResourceLocation, @NotNull ConnectionList> connections() {
        return Collections.unmodifiableMap(this.connections);
    }

    @NotNull
    public PlayerState evaluate(@NotNull PlayerStateMap stateMap, @NotNull PlayerStateCondition.Context context) {
        ResourceLocation currentState = ParagliderPlayerStates.IDLE;
        @Nullable ConnectionList currentConnections = this.connections.get(currentState);
        int currentIndex = 0;
        block0: while (currentConnections != null) {
            while (currentIndex < currentConnections.connections.size()) {
                Connection c;
                if (!(c = currentConnections.connections.get(currentIndex++)).condition().test(context)) continue;
                this.stateEvalIndices.put((Object)currentState, currentIndex);
                currentState = c.state();
                currentConnections = this.connections.get(currentState);
                currentIndex = this.stateEvalIndices.getInt((Object)currentState);
                continue block0;
            }
            if (currentConnections.fallback == null) break;
            this.stateEvalIndices.put((Object)currentState, currentIndex);
            currentState = currentConnections.fallback;
            currentConnections = this.connections.get(currentState);
            currentIndex = this.stateEvalIndices.getInt((Object)currentState);
        }
        this.stateEvalIndices.clear();
        return stateMap.expectState(currentState);
    }

    public String toString() {
        return "PlayerStateConnectionMap{, connections=" + String.valueOf(this.connections) + "}";
    }

    public record ConnectionList(@NotNull @NotNull @Unmodifiable List<@NotNull Connection> connections, @Nullable ResourceLocation fallback) {
        public ConnectionList(@NotNull @NotNull @Unmodifiable List<@NotNull Connection> connections, @Nullable ResourceLocation fallback) {
            this.connections = List.copyOf((Collection)Objects.requireNonNull(connections, "connections == null"));
            for (Connection connection : this.connections) {
                Objects.requireNonNull(connection);
            }
            this.fallback = fallback;
        }
    }

    public record Connection(@NotNull PlayerStateCondition condition, @NotNull ResourceLocation state) {
    }
}

