/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.movement;

import java.util.Objects;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.movement.Movement;
import tictim.paraglider.api.movement.ParagliderPlayerStates;
import tictim.paraglider.api.movement.PlayerState;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.impl.movement.PlayerStateMap;
import tictim.paraglider.wind.Wind;

public abstract class PlayerMovement
implements Movement {
    private final Player player;
    @Nullable
    private PlayerState state;
    private boolean staminaInitialized;
    @Nullable
    private Stamina stamina;

    public PlayerMovement(@NotNull Player player) {
        this.player = Objects.requireNonNull(player, "player == null");
    }

    @NotNull
    public Player player() {
        return this.player;
    }

    @NotNull
    public final Stamina stamina() {
        if (!this.staminaInitialized) {
            this.stamina = Objects.requireNonNull(this.createCustomStamina(), "createCustomStamina() returned null");
            this.staminaInitialized = true;
        }
        return Objects.requireNonNull(this.stamina);
    }

    @NotNull
    protected abstract Stamina createCustomStamina();

    protected abstract boolean isRemote();

    @Override
    @NotNull
    public final PlayerState state() {
        if (this.state != null) {
            return this.state;
        }
        PlayerStateMap stateMap = this.isRemote() ? ParagliderMod.instance().getPlayerStateMap() : ParagliderMod.instance().getLocalPlayerStateMap();
        return stateMap.getIdleState();
    }

    protected final void setState(@NotNull PlayerState state) {
        this.state = state;
    }

    public abstract void update();

    protected void applyMovement() {
        Player player = this.player();
        PlayerState state = this.state();
        if (state.paragliding()) {
            player.fallDistance = 0.0f;
            Vec3 m = player.getDeltaMovement();
            double dy = Math.max(m.y, -0.05);
            if (state.hasFlag(ParagliderPlayerStates.Flags.ASCENDING)) {
                double windAbove = Math.clamp(Wind.getWindAbove(player.level(), player.getBoundingBox()), 0.0, 2.0);
                dy = Math.max(m.y, 0.0 + Math.max(0.0, Mth.lerp((double)(windAbove / 2.0), (double)-0.05, (double)0.25)));
            }
            player.setDeltaMovement(m.x, dy, m.z);
        }
    }

    protected void updateStamina() {
        int recoveryDelay;
        boolean remote = this.isRemote();
        Stamina stamina = this.stamina();
        if (!stamina.updateWithDefaultLogic(remote)) {
            return;
        }
        PlayerState state = this.state();
        int newRecoveryDelay = recoveryDelay = this.recoveryDelay();
        double delta = this.staminaDelta();
        if (delta < 0.0) {
            if (!stamina.isDepleted()) {
                stamina.takeStamina(-delta, false, false, true);
            }
        } else if (recoveryDelay > 0) {
            --newRecoveryDelay;
        } else if (delta > 0.0) {
            stamina.giveStamina(delta, false, true);
        }
        if (recoveryDelay != (newRecoveryDelay = Math.max(0, Math.max(newRecoveryDelay, state.recoveryDelay())))) {
            this.setRecoveryDelay(newRecoveryDelay);
        }
    }
}

