/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.config.Cfg;

public class SimpleVesselContainer
implements VesselContainer {
    public static final Codec<SimpleVesselContainer> CODEC = RecordCodecBuilder.create(b -> b.group((App)Codec.INT.fieldOf("heartContainers").forGetter(SimpleVesselContainer::heartContainer), (App)Codec.INT.fieldOf("staminaVessels").forGetter(SimpleVesselContainer::staminaVessel), (App)Codec.INT.fieldOf("essences").forGetter(SimpleVesselContainer::essence)).apply((Applicative)b, SimpleVesselContainer::new));
    protected int heartContainer;
    protected int staminaVessel;
    protected int essence;
    @Nullable
    protected List<VesselContainer.OnChangeListener> listeners;

    public SimpleVesselContainer() {
    }

    public SimpleVesselContainer(int heartContainer, int staminaVessel, int essence) {
        this.heartContainer = heartContainer;
        this.staminaVessel = staminaVessel;
        this.essence = essence;
    }

    @Override
    public final int heartContainer() {
        return this.heartContainer;
    }

    @Override
    public final int staminaVessel() {
        return this.staminaVessel;
    }

    @Override
    public final int essence() {
        return this.essence;
    }

    @Override
    @NotNull
    public VesselContainer.SetResult setHeartContainer(int amount, boolean simulate, boolean playEffect) {
        if (amount < 0) {
            return VesselContainer.SetResult.TOO_LOW;
        }
        if (amount > Cfg.get().maxHeartContainers()) {
            return VesselContainer.SetResult.TOO_HIGH;
        }
        int change = amount - this.heartContainer;
        if (change == 0) {
            return VesselContainer.SetResult.NO_CHANGE;
        }
        if (!simulate) {
            this.heartContainer = amount;
            this.onChange(VesselContainer.ActionType.HEART_CONTAINER, change, playEffect);
        }
        return VesselContainer.SetResult.OK;
    }

    @Override
    @NotNull
    public VesselContainer.SetResult setStaminaVessel(int amount, boolean simulate, boolean playEffect) {
        if (amount < 0) {
            return VesselContainer.SetResult.TOO_LOW;
        }
        if (amount > Cfg.get().maxStaminaVessels()) {
            return VesselContainer.SetResult.TOO_HIGH;
        }
        int change = amount - this.staminaVessel;
        if (change == 0) {
            return VesselContainer.SetResult.NO_CHANGE;
        }
        if (!simulate) {
            this.staminaVessel = amount;
            this.onChange(VesselContainer.ActionType.STAMINA_VESSEL, change, playEffect);
        }
        return VesselContainer.SetResult.OK;
    }

    @Override
    @NotNull
    public VesselContainer.SetResult setEssence(int amount, boolean simulate, boolean playEffect) {
        if (amount < 0) {
            return VesselContainer.SetResult.TOO_LOW;
        }
        int change = amount - this.essence;
        if (change == 0) {
            return VesselContainer.SetResult.NO_CHANGE;
        }
        if (!simulate) {
            this.essence = amount;
            this.onChange(VesselContainer.ActionType.ESSENCE, change, playEffect);
        }
        return VesselContainer.SetResult.OK;
    }

    @Override
    public int giveHeartContainers(int amount, boolean simulate, boolean playEffect) {
        if ((amount = Math.min(amount, Cfg.get().maxHeartContainers() - this.heartContainer)) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.heartContainer += amount;
            this.onChange(VesselContainer.ActionType.HEART_CONTAINER, amount, playEffect);
        }
        return amount;
    }

    @Override
    public int giveStaminaVessels(int amount, boolean simulate, boolean playEffect) {
        if ((amount = Math.min(amount, Cfg.get().maxStaminaVessels() - this.staminaVessel)) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.staminaVessel += amount;
            this.onChange(VesselContainer.ActionType.STAMINA_VESSEL, amount, playEffect);
        }
        return amount;
    }

    @Override
    public int giveEssences(int amount, boolean simulate, boolean playEffect) {
        if ((amount = Math.min(amount, Integer.MAX_VALUE - this.essence)) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.essence += amount;
            this.onChange(VesselContainer.ActionType.ESSENCE, amount, playEffect);
        }
        return amount;
    }

    @Override
    public int takeHeartContainers(int amount, boolean simulate, boolean playEffect) {
        if ((amount = Math.min(amount, this.heartContainer)) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.heartContainer -= amount;
            this.onChange(VesselContainer.ActionType.HEART_CONTAINER, -amount, playEffect);
        }
        return amount;
    }

    @Override
    public int takeStaminaVessels(int amount, boolean simulate, boolean playEffect) {
        if ((amount = Math.min(amount, this.staminaVessel)) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.staminaVessel -= amount;
            this.onChange(VesselContainer.ActionType.STAMINA_VESSEL, -amount, playEffect);
        }
        return amount;
    }

    @Override
    public int takeEssences(int amount, boolean simulate, boolean playEffect) {
        if ((amount = Math.min(amount, this.essence)) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.essence -= amount;
            this.onChange(VesselContainer.ActionType.ESSENCE, -amount, playEffect);
        }
        return amount;
    }

    protected void onChange(@NotNull VesselContainer.ActionType actionType, int change, boolean playEffect) {
        if (this.listeners != null) {
            for (VesselContainer.OnChangeListener listener : this.listeners) {
                listener.onChange(actionType, change, playEffect);
            }
        }
    }

    @Override
    public void onChange(@NotNull VesselContainer.OnChangeListener onChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<VesselContainer.OnChangeListener>();
        }
        this.listeners.add(onChangeListener);
    }

    @Override
    public void unregisterOnChange(@NotNull VesselContainer.OnChangeListener onChangeListener) {
        if (this.listeners != null) {
            this.listeners.remove(onChangeListener);
        }
    }

    public String toString() {
        return "SimpleVesselContainer{heartContainer=" + this.heartContainer + ", staminaVessel=" + this.staminaVessel + ", essence=" + this.essence + "}";
    }
}

