/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Range;

public class MovementState {
    public static final Codec<MovementState> CODEC = RecordCodecBuilder.create(b -> b.group((App)Codec.INT.fieldOf("recoveryDelay").forGetter(MovementState::recoveryDelay), (App)Codec.INT.fieldOf("panicParaglidingDelay").forGetter(MovementState::panicParaglidingDelay), (App)Codec.BOOL.fieldOf("panicParagliding").forGetter(MovementState::panicParagliding)).apply((Applicative)b, MovementState::new));
    private int recoveryDelay;
    private int panicParaglidingDelay = 10;
    private boolean panicParagliding = false;

    public MovementState() {
    }

    public MovementState(int recoveryDelay, int panicParaglidingDelay, boolean panicParagliding) {
        this.recoveryDelay = Math.max(0, recoveryDelay);
        this.panicParaglidingDelay = panicParaglidingDelay;
        this.panicParagliding = panicParagliding;
    }

    public final @Range(from=0L, to=0x7FFFFFFFL) int recoveryDelay() {
        return this.recoveryDelay;
    }

    public final void setRecoveryDelay(int recoveryDelay) {
        this.recoveryDelay = Math.max(0, recoveryDelay);
    }

    public int panicParaglidingDelay() {
        return this.panicParaglidingDelay;
    }

    public void setPanicParaglidingDelay(int panicParaglidingDelay) {
        this.panicParaglidingDelay = panicParaglidingDelay;
    }

    public boolean panicParagliding() {
        return this.panicParagliding;
    }

    public void setPanicParagliding(boolean panicParagliding) {
        this.panicParagliding = panicParagliding;
    }

    public boolean canDoPanicParagliding() {
        return this.panicParagliding || this.panicParaglidingDelay <= 0;
    }

    public void resetPanicParaglidingState() {
        this.panicParaglidingDelay = 10;
        this.panicParagliding = false;
    }
}

