/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.impl.movement.ClientPlayerMovement;
import tictim.paraglider.impl.movement.PlayerMovement;
import tictim.paraglider.impl.movement.RemotePlayerMovement;
import tictim.paraglider.impl.movement.ServerPlayerMovement;

public final class AttachmentProvider {
    private AttachmentProvider() {
    }

    @NotNull
    public static PlayerMovement createPlayerMovement(@NotNull Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            return new ServerPlayerMovement(sp);
        }
        if (FMLEnvironment.dist.isClient()) {
            return ClientImpl.createPlayerMovement(player);
        }
        return new RemotePlayerMovement(player);
    }

    private static final class ClientImpl {
        private ClientImpl() {
        }

        @NotNull
        static PlayerMovement createPlayerMovement(@NotNull Player player) {
            RemotePlayerMovement remotePlayerMovement;
            if (player instanceof LocalPlayer) {
                LocalPlayer localPlayer = (LocalPlayer)player;
                remotePlayerMovement = new ClientPlayerMovement(localPlayer);
            } else {
                remotePlayerMovement = new RemotePlayerMovement(player);
            }
            return remotePlayerMovement;
        }
    }
}

