/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.event;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.movement.Movement;
import tictim.paraglider.bargain.BargainHandler;
import tictim.paraglider.impl.movement.PlayerMovement;
import tictim.paraglider.impl.movement.ServerPlayerMovement;
import tictim.paraglider.network.ParagliderNetwork;

@EventBusSubscriber(modid="paraglider")
public final class ParagliderEventHandler {
    private ParagliderEventHandler() {
    }

    public static void onPlayerInteract(PlayerInteractEvent event) {
        Movement movement;
        if (!(event instanceof ICancellableEvent)) {
            return;
        }
        ICancellableEvent cancellable = (ICancellableEvent)event;
        if (event.getHand() == InteractionHand.OFF_HAND && (movement = Movement.get(event.getEntity())).state().paragliding()) {
            cancellable.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerStartUseItem(LivingEntityUseItemEvent.Start event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Movement movement = Movement.get(player);
        if (movement.state().paragliding()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickUseItem(LivingEntityUseItemEvent.Tick event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Movement movement = Movement.get(player);
        if (movement.state().paragliding()) {
            player.stopUsingItem();
        }
    }

    @SubscribeEvent
    public static void afterPlayerTick(PlayerTickEvent.Post event) {
        Movement movement = Movement.get(event.getEntity());
        if (movement instanceof PlayerMovement) {
            PlayerMovement playerMovement = (PlayerMovement)movement;
            playerMovement.update();
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Player tracking;
        Entity entity;
        block3: {
            block2: {
                entity = event.getTarget();
                if (!(entity instanceof Player)) break block2;
                tracking = (Player)entity;
                entity = event.getEntity();
                if (entity instanceof ServerPlayer) break block3;
            }
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ParagliderNetwork.get().syncRemoteMovement((Entity)tracking, player, Movement.get(tracking).state().id());
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Movement movement = Movement.get(event.getEntity());
        if (movement instanceof ServerPlayerMovement) {
            ServerPlayerMovement serverPlayerMovement = (ServerPlayerMovement)movement;
            serverPlayerMovement.markForSync();
        }
    }

    @SubscribeEvent
    public static void afterServerTick(ServerTickEvent.Post event) {
        BargainHandler.update();
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ParagliderNetwork.get().syncStateMap(player2, ParagliderMod.instance().getLocalPlayerStateMap());
            Movement movement = Movement.get((Player)player2);
            if (movement instanceof ServerPlayerMovement) {
                ServerPlayerMovement serverPlayerMovement = (ServerPlayerMovement)movement;
                serverPlayerMovement.markForSync();
            }
        }
    }

    static {
        NeoForge.EVENT_BUS.addListener(event -> ParagliderEventHandler.onPlayerInteract((PlayerInteractEvent)event));
        NeoForge.EVENT_BUS.addListener(event -> ParagliderEventHandler.onPlayerInteract((PlayerInteractEvent)event));
        NeoForge.EVENT_BUS.addListener(event -> ParagliderEventHandler.onPlayerInteract((PlayerInteractEvent)event));
        NeoForge.EVENT_BUS.addListener(event -> ParagliderEventHandler.onPlayerInteract((PlayerInteractEvent)event));
        NeoForge.EVENT_BUS.addListener(event -> ParagliderEventHandler.onPlayerInteract((PlayerInteractEvent)event));
        NeoForge.EVENT_BUS.addListener(event -> ParagliderEventHandler.onPlayerInteract((PlayerInteractEvent)event));
        NeoForge.EVENT_BUS.addListener(event -> ParagliderEventHandler.onPlayerInteract((PlayerInteractEvent)event));
    }
}

