/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.event;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import tictim.paraglider.ParagliderClientMod;
import tictim.paraglider.api.movement.Movement;
import tictim.paraglider.client.render.InGameStaminaWheelRenderer;
import tictim.paraglider.client.screen.BargainScreen;
import tictim.paraglider.client.screen.ParagliderSettingsScreen;

@EventBusSubscriber(modid="paraglider", value={Dist.CLIENT})
public final class ParagliderClientEventHandler {
    private ParagliderClientEventHandler() {
    }

    @SubscribeEvent
    public static void onOffHandRender(RenderHandEvent event) {
        if (event.getHand() != InteractionHand.OFF_HAND) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Movement m = Movement.get((Player)player);
        if (m.state().paragliding()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void beforeCrosshairRender(RenderGuiLayerEvent.Pre event) {
        if (event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR) && Minecraft.getInstance().screen instanceof BargainScreen) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        if (Minecraft.getInstance().screen == null && ParagliderClientMod.instance().getParagliderSettingsKey().consumeClick()) {
            Minecraft.getInstance().setScreen((Screen)new ParagliderSettingsScreen());
        }
    }

    @SubscribeEvent
    public static void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        if (event.isPickBlock()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Movement movement = Movement.get((Player)player);
        if (movement.state().paragliding()) {
            event.setSwingHand(false);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onDrawBlockSelection(RenderHighlightEvent.Block event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Movement movement = Movement.get((Player)player);
        if (movement.state().paragliding()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClientLoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        InGameStaminaWheelRenderer.get().reset();
    }
}

