/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.worldgen.BaseHornedStatuePiece;

public class NetherHornedStatue
extends Structure {
    public static final MapCodec<NetherHornedStatue> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)NetherHornedStatue.settingsCodec((RecordCodecBuilder.Instance)b), (App)HeightProvider.CODEC.fieldOf("height").forGetter(s -> s.height)).apply((Applicative)b, NetherHornedStatue::new));
    private static final ResourceLocation TEMPLATE = ParagliderAPI.id("nether_horned_statue");
    private static final BlockPos PIVOT = new BlockPos(2, 1, 2);
    public final HeightProvider height;

    @NotNull
    public static StructurePieceType.StructureTemplateType pieceType() {
        return BaseHornedStatuePiece.createType(() -> Contents.get().netherHornedStatuePiece(), PIVOT);
    }

    public NetherHornedStatue(@NotNull Structure.StructureSettings structureSettings, @NotNull HeightProvider height) {
        super(structureSettings);
        this.height = height;
    }

    @NotNull
    public Optional<Structure.GenerationStub> findGenerationPoint(@NotNull Structure.GenerationContext ctx) {
        WorldgenRandom r = ctx.random();
        int x = ctx.chunkPos().getMinBlockX() + r.nextInt(16);
        int z = ctx.chunkPos().getMinBlockZ() + r.nextInt(16);
        int seaLevel = ctx.chunkGenerator().getSeaLevel();
        int y = this.height.sample((RandomSource)r, new WorldGenerationContext(ctx.chunkGenerator(), ctx.heightAccessor()));
        NoiseColumn col = ctx.chunkGenerator().getBaseColumn(x, z, ctx.heightAccessor(), ctx.randomState());
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos(x, y, z);
        while (y > seaLevel) {
            BlockState state = col.getBlock(y);
            BlockState bottomState = col.getBlock(--y);
            if (!state.isAir() || !bottomState.is(Blocks.SOUL_SAND) && !bottomState.isFaceSturdy((BlockGetter)EmptyBlockGetter.INSTANCE, (BlockPos)mpos.setY(y), Direction.UP)) continue;
            break;
        }
        if (y <= seaLevel) {
            return Optional.empty();
        }
        BlockPos pos = new BlockPos(x, y - 1, z);
        return Optional.of(new Structure.GenerationStub(pos, b -> b.addPiece((StructurePiece)new BaseHornedStatuePiece(Contents.get().netherHornedStatuePiece(), ctx.structureTemplateManager(), TEMPLATE, pos).rot(PIVOT, Rotation.getRandom((RandomSource)r), false))));
    }

    @NotNull
    public StructureType<?> type() {
        return Contents.get().netherHornedStatue();
    }

    @NotNull
    public GenerationStep.Decoration step() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }
}

