/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.recipe.preview;

import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.api.bargain.BargainPreview;
import tictim.paraglider.contents.Contents;

public record VesselPreview(@NotNull VesselType vesselType, int quantity) implements BargainPreview<VesselPreview>
{
    public static final BargainPreview.Type<VesselPreview> TYPE = new BargainPreview.Type(StreamCodec.of((buffer, vesselPreview) -> {
        buffer.writeEnum((Enum)vesselPreview.vesselType);
        buffer.writeVarInt(vesselPreview.quantity);
    }, buffer -> new VesselPreview((VesselType)buffer.readEnum(VesselType.class), buffer.readVarInt())));

    @Override
    @NotNull
    public List<ItemStack> display() {
        return this.vesselType.display();
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull Component> getTooltip() {
        return List.of(this.quantity == 1 ? Component.translatable((String)this.vesselType.singleTooltipKey) : Component.translatable((String)this.vesselType.multiTooltipKey, (Object[])new Object[]{this.quantity}));
    }

    @Override
    @NotNull
    public BargainPreview.Type<VesselPreview> type() {
        return TYPE;
    }

    public static enum VesselType implements StringRepresentable
    {
        HEART_CONTAINER(() -> List.of(new ItemStack((ItemLike)Contents.get().heartContainer())), "bargain.paraglider.heart_container"),
        STAMINA_VESSEL(() -> List.of(new ItemStack((ItemLike)Contents.get().staminaVessel())), "bargain.paraglider.stamina_vessel"),
        ESSENCE(() -> List.of(new ItemStack((ItemLike)Contents.get().essence())), "bargain.paraglider.essence");

        private final String id = this.name().toLowerCase(Locale.ROOT);
        private final Supplier<List<ItemStack>> display;
        private final String singleTooltipKey;
        private final String multiTooltipKey;
        @Nullable
        private List<ItemStack> displayCache;

        private VesselType(Supplier<List<ItemStack>> display, String singleTooltipKey) {
            this.display = display;
            this.singleTooltipKey = singleTooltipKey;
            this.multiTooltipKey = singleTooltipKey + ".s";
        }

        public List<ItemStack> display() {
            if (this.displayCache == null) {
                this.displayCache = this.display.get();
            }
            return this.displayCache;
        }

        @NotNull
        public String getSerializedName() {
            return this.id;
        }
    }
}

