/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.recipe;

import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import org.jetbrains.annotations.NotNull;

public enum WaterBottleIngredientType implements ICustomIngredient
{
    INSTANCE;

    private final IngredientType<WaterBottleIngredientType> type = new IngredientType(MapCodec.unit((Object)((Object)this)), StreamCodec.unit((Object)((Object)this)));

    public boolean test(@NotNull ItemStack stack) {
        return stack.is(Items.POTION) && ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.WATER);
    }

    @NotNull
    public Stream<ItemStack> getItems() {
        return Stream.of(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER));
    }

    public boolean isSimple() {
        return false;
    }

    @NotNull
    public IngredientType<?> getType() {
        return this.type;
    }

    public String toString() {
        return "WaterBottleIngredientType";
    }
}

