/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.contents.recipe.QuantifiedIngredient;
import tictim.paraglider.contents.recipe.QuantifiedItem;
import tictim.paraglider.contents.recipe.SimpleBargain;

public class SimpleBargainSerializer
implements RecipeSerializer<SimpleBargain> {
    private static final MapCodec<SimpleBargain> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)Codec.mapEither((MapCodec)ResourceLocation.CODEC.fieldOf("bargainType"), (MapCodec)ResourceLocation.CODEC.fieldOf("owner")).xmap(e -> (ResourceLocation)e.map(Function.identity(), Function.identity()), Either::left).forGetter(SimpleBargain::getBargainType), (App)DemandComponent.CODEC.codec().optionalFieldOf("demands", (Object)DemandComponent.DEFAULT).forGetter(r -> new DemandComponent(r.getItemDemands(), r.getHeartContainerDemands(), r.getStaminaVesselDemands(), r.getEssenceDemands())), (App)OfferComponent.CODEC.codec().optionalFieldOf("offers", (Object)OfferComponent.DEFAULT).forGetter(r -> new OfferComponent(r.getItemOffers(), r.getHeartContainerOffers(), r.getStaminaVesselOffers(), r.getEssenceOffers())), (App)Codec.STRING.listOf().optionalFieldOf("tags", List.of()).xmap(Set::copyOf, List::copyOf).forGetter(SimpleBargain::getUserTags)).apply((Applicative)b, (bargainType, demands, offers, tags) -> new SimpleBargain((ResourceLocation)bargainType, demands.items, demands.heartContainers, demands.staminaVessels, demands.essences, offers.items, offers.heartContainers, offers.staminaVessels, offers.essences, (Set<String>)tags)));
    private static final StreamCodec<RegistryFriendlyByteBuf, SimpleBargain> STREAM_CODEC = StreamCodec.of(SimpleBargainSerializer::toNetwork, SimpleBargainSerializer::fromNetwork);

    @NotNull
    public MapCodec<SimpleBargain> codec() {
        return CODEC;
    }

    @NotNull
    public StreamCodec<RegistryFriendlyByteBuf, SimpleBargain> streamCodec() {
        return STREAM_CODEC;
    }

    @NotNull
    private static SimpleBargain fromNetwork(@NotNull RegistryFriendlyByteBuf buffer) {
        ResourceLocation bargainType = buffer.readResourceLocation();
        ArrayList<QuantifiedIngredient> itemDemands = new ArrayList<QuantifiedIngredient>();
        int size = buffer.readVarInt();
        for (int i = 0; i < size; ++i) {
            itemDemands.add((QuantifiedIngredient)QuantifiedIngredient.STREAM_CODEC.decode((Object)buffer));
        }
        int heartContainerDemands = buffer.readVarInt();
        int staminaVesselDemands = buffer.readVarInt();
        int essenceDemands = buffer.readVarInt();
        ArrayList<QuantifiedItem> itemOffers = new ArrayList<QuantifiedItem>();
        int size2 = buffer.readVarInt();
        for (int i = 0; i < size2; ++i) {
            itemOffers.add((QuantifiedItem)QuantifiedItem.STREAM_CODEC.decode((Object)buffer));
        }
        int heartContainerOffers = buffer.readVarInt();
        int staminaVesselOffers = buffer.readVarInt();
        int essenceOffers = buffer.readVarInt();
        ObjectOpenHashSet userTags = new ObjectOpenHashSet();
        int size3 = buffer.readVarInt();
        for (int i = 0; i < size3; ++i) {
            userTags.add(buffer.readUtf());
        }
        return new SimpleBargain(bargainType, itemDemands, heartContainerDemands, staminaVesselDemands, essenceDemands, itemOffers, heartContainerOffers, staminaVesselOffers, essenceOffers, (Set<String>)userTags);
    }

    private static void toNetwork(@NotNull RegistryFriendlyByteBuf buffer, @NotNull SimpleBargain recipe) {
        buffer.writeResourceLocation(recipe.getBargainType());
        List<QuantifiedIngredient> itemDemands = recipe.getItemDemands();
        buffer.writeVarInt(itemDemands.size());
        for (QuantifiedIngredient quantifiedIngredient : itemDemands) {
            QuantifiedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)quantifiedIngredient);
        }
        buffer.writeVarInt(recipe.getHeartContainerDemands());
        buffer.writeVarInt(recipe.getStaminaVesselDemands());
        buffer.writeVarInt(recipe.getEssenceDemands());
        List<QuantifiedItem> itemOffers = recipe.getItemOffers();
        buffer.writeVarInt(itemOffers.size());
        for (QuantifiedItem offer : itemOffers) {
            QuantifiedItem.STREAM_CODEC.encode((Object)buffer, (Object)offer);
        }
        buffer.writeVarInt(recipe.getHeartContainerOffers());
        buffer.writeVarInt(recipe.getStaminaVesselOffers());
        buffer.writeVarInt(recipe.getEssenceOffers());
        Set<String> set = recipe.getUserTags();
        buffer.writeVarInt(set.size());
        for (String userTag : set) {
            buffer.writeUtf(userTag);
        }
    }

    private record DemandComponent(List<QuantifiedIngredient> items, int heartContainers, int staminaVessels, int essences) {
        private static final DemandComponent DEFAULT = new DemandComponent(List.of(), 0, 0, 0);
        private static final MapCodec<DemandComponent> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)QuantifiedIngredient.CODEC.codec().listOf().optionalFieldOf("items", List.of()).forGetter(DemandComponent::items), (App)Codec.INT.optionalFieldOf("heartContainers", (Object)0).forGetter(DemandComponent::heartContainers), (App)Codec.INT.optionalFieldOf("staminaVessels", (Object)0).forGetter(DemandComponent::staminaVessels), (App)Codec.INT.optionalFieldOf("essences", (Object)0).forGetter(DemandComponent::essences)).apply((Applicative)b, DemandComponent::new));
    }

    private record OfferComponent(@NotNull List<QuantifiedItem> items, int heartContainers, int staminaVessels, int essences) {
        private static final OfferComponent DEFAULT = new OfferComponent(List.of(), 0, 0, 0);
        private static final MapCodec<OfferComponent> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)QuantifiedItem.CODEC.codec().listOf().optionalFieldOf("items", List.of()).forGetter(OfferComponent::items), (App)Codec.INT.optionalFieldOf("heartContainers", (Object)0).forGetter(OfferComponent::heartContainers), (App)Codec.INT.optionalFieldOf("staminaVessels", (Object)0).forGetter(OfferComponent::staminaVessels), (App)Codec.INT.optionalFieldOf("essences", (Object)0).forGetter(OfferComponent::essences)).apply((Applicative)b, OfferComponent::new));
    }
}

