/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.contents.Contents;

public class CosmeticRecipe
implements CraftingRecipe {
    private final String group;
    private final CraftingBookCategory category;
    private final Ingredient input;
    private final List<Ingredient> reagents;
    private final Item resultItem;

    public CosmeticRecipe(String group, CraftingBookCategory category, Ingredient input, List<Ingredient> reagents, Item resultItem) {
        this.group = group;
        this.category = category;
        this.input = input;
        this.reagents = reagents;
        this.resultItem = resultItem;
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level level) {
        boolean inputSeen = false;
        boolean[] reagentsSeen = new boolean[this.reagents.size()];
        block0: for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (this.input.test(stack) && !stack.is(this.resultItem)) {
                if (inputSeen) {
                    return false;
                }
                inputSeen = true;
                continue;
            }
            for (int j = 0; j < this.reagents.size(); ++j) {
                if (reagentsSeen[j] || !this.reagents.get(j).test(stack)) continue;
                reagentsSeen[j] = true;
                continue block0;
            }
            return false;
        }
        for (boolean b : reagentsSeen) {
            if (b) continue;
            return false;
        }
        return inputSeen;
    }

    @NotNull
    public ItemStack assemble(CraftingInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty() || !this.input.test(stack) || stack.is(this.resultItem)) continue;
            ItemStack result = new ItemStack((ItemLike)this.resultItem, stack.getCount());
            result.applyComponents(stack.getComponents());
            return result;
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.input);
        list.addAll(this.reagents);
        return list;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return new ItemStack((ItemLike)this.resultItem);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.reagents.size() + 1;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList list = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        boolean inputSeen = false;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (!inputSeen && this.input.test(stack) && !stack.is(this.resultItem)) {
                inputSeen = true;
                list.set(i, (Object)stack.getCraftingRemainingItem());
                continue;
            }
            list.set(i, (Object)stack.copyWithCount(1));
        }
        return list;
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    @NotNull
    public RecipeSerializer<? extends CraftingRecipe> getSerializer() {
        return Contents.get().cosmeticRecipeSerializer();
    }

    @NotNull
    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public static class Serializer
    implements RecipeSerializer<CosmeticRecipe> {
        private static final MapCodec<CosmeticRecipe> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(r -> r.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(r -> r.category), (App)Ingredient.CODEC.fieldOf("input").forGetter(r -> r.input), (App)Ingredient.CODEC.listOf(1, 8).fieldOf("reagents").forGetter(r -> r.reagents), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("result").forGetter(r -> r.resultItem)).apply((Applicative)b, CosmeticRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CosmeticRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, r -> r.group, (StreamCodec)CraftingBookCategory.STREAM_CODEC, r -> r.category, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.input, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), r -> r.reagents, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), r -> r.resultItem, CosmeticRecipe::new);

        @NotNull
        public MapCodec<CosmeticRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CosmeticRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

