/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.loot;

import com.mojang.serialization.MapCodec;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.config.Cfg;

public enum ParagliderLootConditions implements LootItemCondition
{
    WITHER_DROPS_VESSEL("config_wither_drops_vessel"),
    ELDER_GUARDIAN_DROPS_SPIRIT_ORB("config_elder_guardian_drops_spirit_orb"),
    SPIRIT_ORB_LOOTS("config_spirit_orb_loots");

    private final LootItemConditionType type = new LootItemConditionType(MapCodec.unit((Object)((Object)this)));
    private final String id;

    private ParagliderLootConditions(String id) {
        this.id = id;
    }

    @NotNull
    public LootItemConditionType getType() {
        return this.type;
    }

    public boolean test(@NotNull LootContext lootContext) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Cfg.get().witherDropsVessel();
            case 1 -> Cfg.get().elderGuardianDropsSpiritOrb();
            case 2 -> Cfg.get().spiritOrbLoots();
        };
    }

    public static void register(DeferredRegister<LootItemConditionType> register) {
        for (ParagliderLootConditions c : ParagliderLootConditions.values()) {
            LootItemConditionType type = c.getType();
            register.register(c.id, () -> type);
        }
    }
}

