/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.config.Cfg;
import tictim.paraglider.contents.Contents;

public class ParagliderLoot
extends LootModifier {
    public static final MapCodec<ParagliderLoot> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)Codec.BOOL.fieldOf("dekuLeaf").forGetter(m -> m.dekuLeaf)).and(ParagliderLoot.codecStart((RecordCodecBuilder.Instance)b).t1()).apply((Applicative)b, ParagliderLoot::new));
    public final boolean dekuLeaf;

    public ParagliderLoot(boolean dekuLeaf, LootItemCondition ... conditions) {
        super(conditions);
        this.dekuLeaf = dekuLeaf;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext context) {
        Cfg.TotwCompatConfigOption configOption = Cfg.get().paragliderInTowersOfTheWild();
        if (configOption != Cfg.TotwCompatConfigOption.DISABLE) {
            ItemStack stack = new ItemStack((ItemLike)(configOption == Cfg.TotwCompatConfigOption.DEKU_LEAF_ONLY || configOption != Cfg.TotwCompatConfigOption.PARAGLIDER_ONLY && this.dekuLeaf ? Contents.get().dekuLeaf() : Contents.get().paraglider()));
            RandomSource random = context.getRandom();
            if (random.nextBoolean()) {
                stack = DyedItemColor.applyDyes((ItemStack)stack, List.of(DyeItem.byColor((DyeColor)DyeColor.byId((int)random.nextInt(16))), DyeItem.byColor((DyeColor)DyeColor.byId((int)random.nextInt(16)))));
            }
            generatedLoot.add((Object)stack);
        }
        return generatedLoot;
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

